/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.RuntimeExecutorsBinder;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.servlet.ServletPropertiesDelegate;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.PersistenceUnitBinder;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private static final Type RequestTYPE = new TypeLiteral<Ref<HttpServletRequest>>(){}.getType();
    private static final Type ResponseTYPE = new TypeLiteral<Ref<HttpServletResponse>>(){}.getType();
    private static final AsyncContextDelegate DefaultAsyncDELEGATE = new AsyncContextDelegate(){

        @Override
        public void suspend() throws IllegalStateException {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_PROCESSING_NOT_SUPPORTED());
        }

        @Override
        public void complete() {
        }
    };
    final ApplicationHandler appHandler;
    final ScheduledExecutorService backgroundTaskScheduler;
    final WebConfig webConfig;
    final boolean forwardOn404;
    private final AsyncContextDelegateProvider asyncExtensionDelegate;

    private AsyncContextDelegateProvider getAsyncExtensionDelegate() {
        Iterator<AsyncContextDelegateProvider> providers = Providers.getAllProviders(this.appHandler.getServiceLocator(), AsyncContextDelegateProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        return new AsyncContextDelegateProvider(){

            @Override
            public AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
                return DefaultAsyncDELEGATE;
            }
        };
    }

    public WebComponent(WebConfig webConfig, ResourceConfig resourceConfig) throws ServletException {
        this.webConfig = webConfig;
        if (resourceConfig == null) {
            resourceConfig = WebComponent.createResourceConfig(webConfig);
        }
        WebComponent.configure(resourceConfig);
        resourceConfig.register(new WebComponentBinder(resourceConfig.getProperties()));
        this.appHandler = new ApplicationHandler(resourceConfig);
        this.asyncExtensionDelegate = this.getAsyncExtensionDelegate();
        this.forwardOn404 = webConfig.getConfigType().equals((Object)WebConfig.ConfigType.FilterConfig) && resourceConfig.isProperty("jersey.config.servlet.filter.forwardOn404");
        this.backgroundTaskScheduler = this.appHandler.getServiceLocator().getService(ScheduledExecutorService.class, new RuntimeExecutorsBinder.BackgroundSchedulerLiteral());
    }

    public Value<Integer> service(URI baseUri, URI requestUri, final HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws ServletException, IOException {
        ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, servletRequest.getMethod(), this.getSecurityContext(servletRequest), new ServletPropertiesDelegate(servletRequest));
        requestContext.setEntityStream((InputStream)servletRequest.getInputStream());
        this.addRequestHeaders(servletRequest, requestContext);
        try {
            this.filterFormParameters(servletRequest, requestContext);
            final ResponseWriter responseWriter = new ResponseWriter(this.forwardOn404, servletResponse, this.asyncExtensionDelegate.createDelegate(servletRequest, servletResponse), this.backgroundTaskScheduler);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(RequestTYPE, new Annotation[0])).set(servletRequest);
                    ((Ref)locator.getService(ResponseTYPE, new Annotation[0])).set(servletResponse);
                }
            });
            requestContext.setWriter(responseWriter);
            this.appHandler.handle(requestContext);
            return Values.lazy(new Value<Integer>(){

                @Override
                public Integer get() {
                    return responseWriter.getResponseStatus();
                }
            });
        }
        catch (HeaderValueException hve) {
            Response.Status status = Response.Status.BAD_REQUEST;
            servletResponse.sendError(status.getStatusCode(), status.getReasonPhrase());
            return Values.of(status.getStatusCode());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private static ResourceConfig createResourceConfig(WebConfig config) throws ServletException {
        Map<String, Object> initParams = WebComponent.getInitParams(config);
        Map<String, Object> contextParams = WebComponent.getContextParams(config.getServletContext());
        String jaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (jaxrsApplicationClassName == null) {
            ResourceConfig rc = new ResourceConfig().addProperties(initParams).addProperties(contextParams);
            String webApp = config.getInitParameter("jersey.config.servlet.provider.webapp");
            if (webApp != null && !"false".equals(webApp)) {
                rc.registerFinder(new WebAppResourcesScanner(config.getServletContext()));
            }
            return rc;
        }
        try {
            Class jaxrsApplicationClass = AccessController.doPrivileged(ReflectionHelper.classForNameWithExceptionPEA(jaxrsApplicationClassName));
            if (Application.class.isAssignableFrom(jaxrsApplicationClass)) {
                return ResourceConfig.forApplicationClass(jaxrsApplicationClass).addProperties(initParams).addProperties(contextParams);
            }
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_PARENT_CLASS_INVALID(jaxrsApplicationClassName, Application.class));
        }
        catch (PrivilegedActionException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), (Throwable)e);
        }
    }

    private static void configure(ResourceConfig resourceConfig) throws ServletException {
        ServletContainerProvider[] allServletContainerProviders;
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders()) {
            servletContainerProvider.configure(resourceConfig);
        }
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, value);
            }
        }
    }

    private static Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    public static Map<String, Object> getContextParams(ServletContext servletContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, servletContext.getAttribute(name));
        }
        return props;
    }

    private void filterFormParameters(HttpServletRequest servletRequest, ContainerRequest containerRequest) {
        if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, containerRequest.getMediaType()) && !containerRequest.hasEntity()) {
            Form form = new Form();
            Enumeration parameterNames = servletRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String[] values = servletRequest.getParameterValues(name);
                form.asMap().put(name, (String)((Object)Arrays.asList(values)));
            }
            if (!form.asMap().isEmpty()) {
                containerRequest.setProperty("jersey.config.server.representation.decoded.form", form);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.FORM_PARAM_CONSUMED(containerRequest.getRequestUri()));
                }
            }
        }
    }

    private class WebComponentBinder
    extends AbstractBinder {
        private final Map<String, Object> applicationProperties;

        private WebComponentBinder(Map<String, Object> applicationProperties) {
            this.applicationProperties = applicationProperties;
        }

        @Override
        protected void configure() {
            this.bindFactory(HttpServletRequestReferencingFactory.class).to(HttpServletRequest.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletRequest>>(){}).in(RequestScoped.class);
            this.bindFactory(HttpServletResponseReferencingFactory.class).to(HttpServletResponse.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletResponse>>(){}).in(RequestScoped.class);
            this.bindFactory(new Factory<ServletContext>(){

                @Override
                public ServletContext provide() {
                    return WebComponent.this.webConfig.getServletContext();
                }

                @Override
                public void dispose(ServletContext instance) {
                }
            }).to(ServletContext.class).in(Singleton.class);
            final ServletConfig servletConfig = WebComponent.this.webConfig.getServletConfig();
            if (WebComponent.this.webConfig.getConfigType() == WebConfig.ConfigType.ServletConfig) {
                this.bindFactory(new Factory<ServletConfig>(){

                    @Override
                    public ServletConfig provide() {
                        return servletConfig;
                    }

                    @Override
                    public void dispose(ServletConfig instance) {
                    }
                }).to(ServletConfig.class).in(Singleton.class);
                Enumeration initParams = servletConfig.getInitParameterNames();
                while (initParams.hasMoreElements()) {
                    String initParamName = (String)initParams.nextElement();
                    if (!initParamName.startsWith("unit:")) continue;
                    this.install(new PersistenceUnitBinder());
                    break;
                }
            } else {
                this.bindFactory(new Factory<FilterConfig>(){

                    @Override
                    public FilterConfig provide() {
                        return WebComponent.this.webConfig.getFilterConfig();
                    }

                    @Override
                    public void dispose(FilterConfig instance) {
                    }
                }).to(FilterConfig.class).in(Singleton.class);
            }
            this.bindFactory(new Factory<WebConfig>(){

                @Override
                public WebConfig provide() {
                    return WebComponent.this.webConfig;
                }

                @Override
                public void dispose(WebConfig instance) {
                }
            }).to(WebConfig.class).in(Singleton.class);
            this.install(new ServiceFinderBinder<AsyncContextDelegateProvider>(AsyncContextDelegateProvider.class, this.applicationProperties, RuntimeType.SERVER));
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

