/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.UriTemplate;

class PushMatchedTemplateRouter
implements Router {
    private final Provider<RoutingContext> routingContextProvider;
    private final UriTemplate resourceTemplate;
    private final UriTemplate methodTemplate;

    private PushMatchedTemplateRouter(Provider<RoutingContext> routingContextProvider, UriTemplate resourceTemplate, UriTemplate methodTemplate) {
        this.routingContextProvider = routingContextProvider;
        this.resourceTemplate = resourceTemplate;
        this.methodTemplate = methodTemplate;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        RoutingContext rc = this.routingContextProvider.get();
        rc.pushTemplates(this.resourceTemplate, this.methodTemplate);
        return Router.Continuation.of(request);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContext;

        Builder() {
        }

        PushMatchedTemplateRouter build(UriTemplate resourceTemplate, UriTemplate methodTemplate) {
            return new PushMatchedTemplateRouter(this.routingContext, resourceTemplate, methodTemplate);
        }

        PushMatchedTemplateRouter build(UriTemplate resourceTemplate) {
            return new PushMatchedTemplateRouter(this.routingContext, resourceTemplate, null);
        }
    }
}

