/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.ResourceMethod;

class PushMatchedMethodRouter
implements Router {
    private final ResourceMethod resourceMethod;
    private final Provider<RoutingContext> routingContext;

    private PushMatchedMethodRouter(ResourceMethod resourceMethod, Provider<RoutingContext> routingContext) {
        this.resourceMethod = resourceMethod;
        this.routingContext = routingContext;
    }

    @Override
    public Router.Continuation apply(ContainerRequest data) {
        switch (this.resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                this.routingContext.get().setMatchedResourceMethod(this.resourceMethod);
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                this.routingContext.get().pushMatchedLocator(this.resourceMethod);
            }
        }
        return Router.Continuation.of(data);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContext;

        Builder() {
        }

        PushMatchedMethodRouter build(ResourceMethod resourceMethod) {
            return new PushMatchedMethodRouter(resourceMethod, this.routingContext);
        }
    }
}

