/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.SingleMatchResult;

final class MatchResultInitializerRouter
implements Router {
    private final Provider<RoutingContext> contextProvider;
    private final Router rootRouter;

    private MatchResultInitializerRouter(Provider<RoutingContext> contextProvider, Router rootRouter) {
        this.contextProvider = contextProvider;
        this.rootRouter = rootRouter;
    }

    @Override
    public Router.Continuation apply(ContainerRequest requestContext) {
        RoutingContext rc = this.contextProvider.get();
        rc.pushMatchResult(new SingleMatchResult(requestContext.getPath(false)));
        return Router.Continuation.of(requestContext, this.rootRouter);
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> contextProvider;

        public MatchResultInitializerRouter build(Router rootRoute) {
            return new MatchResultInitializerRouter(this.contextProvider, rootRoute);
        }
    }
}

