/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.AbstractMultivaluedMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;

public final class HeadersFactory {
    public static AbstractMultivaluedMap<String, String> createInbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<String>();
    }

    public static <V> MultivaluedMap<String, V> empty() {
        return ImmutableMultivaluedMap.empty();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<Object>();
    }

    public static String asString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate<?> hp;
        if (headerValue == null) {
            return null;
        }
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> asStringList(List<Object> headerValues, RuntimeDelegate rd) {
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        final RuntimeDelegate delegate = rd == null ? RuntimeDelegate.getInstance() : rd;
        return Lists.transform(headerValues, new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input == null ? "[null]" : HeadersFactory.asString(input, delegate);
            }
        });
    }

    public static MultivaluedMap<String, String> asStringHeaders(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        final RuntimeDelegate rd = RuntimeDelegate.getInstance();
        return new AbstractMultivaluedMap<String, String>(Maps.transformValues(headers, new Function<List<Object>, List<String>>(){

            @Override
            public List<String> apply(List<Object> input) {
                return HeadersFactory.asStringList(input, rd);
            }
        })){};
    }

    public static String asHeaderString(List<Object> values, RuntimeDelegate rd) {
        if (values == null) {
            return null;
        }
        Iterator<String> stringValues = HeadersFactory.asStringList(values, rd).iterator();
        if (!stringValues.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(stringValues.next());
        while (stringValues.hasNext()) {
            buffer.append(',').append(stringValues.next());
        }
        return buffer.toString();
    }

    private HeadersFactory() {
    }
}

