/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

public class MultiPartProperties {
    public static final int DEFAULT_BUFFER_THRESHOLD = 4096;
    public static final String MULTI_PART_CONFIG_RESOURCE = "jersey-multipart-config.properties";
    public static final String BUFFER_THRESHOLD = "jersey.config.multipart.bufferThreshold";
    private int bufferThreshold = 4096;

    public MultiPartProperties() {
        this.configure();
    }

    public int getBufferThreshold() {
        return this.bufferThreshold;
    }

    private void configure() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        InputStream stream = null;
        try {
            stream = loader.getResourceAsStream(MULTI_PART_CONFIG_RESOURCE);
            if (stream == null) {
                return;
            }
            Properties props = new Properties();
            props.load(stream);
            String value = null;
            value = props.getProperty(BUFFER_THRESHOLD);
            if (value != null) {
                System.out.println("Setting bufferThreshold to " + value);
                this.bufferThreshold = Integer.valueOf(value);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static class Feature
    implements javax.ws.rs.core.Feature {
        @Override
        public boolean configure(FeatureContext context) {
            context.register(MultiPartContextResolver.class);
            return true;
        }

        @Provider
        private static class MultiPartContextResolver
        implements ContextResolver<MultiPartProperties> {
            private MultiPartContextResolver() {
            }

            @Override
            public MultiPartProperties getContext(Class<?> type) {
                return new MultiPartProperties();
            }
        }
    }
}

