/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination;

import java.util.Enumeration;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;

public class CommandPropagator
implements Runnable {
    protected RemoteCommandManager rcm;
    protected Command command;
    protected RemoteConnection connection;

    public CommandPropagator(RemoteCommandManager rcm, Command command) {
        this.rcm = rcm;
        this.command = command;
    }

    public CommandPropagator(RemoteCommandManager rcm, Command command, RemoteConnection connection) {
        this(rcm, command);
        this.connection = connection;
    }

    protected RemoteCommandManager getRemoteCommandManager() {
        return this.rcm;
    }

    protected Command getCommand() {
        return this.command;
    }

    public void synchronousPropagateCommand() {
        this.rcm.logDebug("sync_propagation", null);
        Enumeration connections = this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation().elements();
        while (connections.hasMoreElements()) {
            this.connection = (RemoteConnection)connections.nextElement();
            this.propagateCommand(this.connection);
        }
    }

    public void asynchronousPropagateCommand() {
        this.rcm.logDebug("async_propagation", null);
        this.rcm.getServerPlatform().launchContainerRunnable(this);
    }

    public void propagateCommand(RemoteConnection conn) {
        Object[] arguments = new Object[]{this.command.getClass().getName(), conn.getServiceId()};
        this.rcm.logDebug("propagate_command_to", arguments);
        try {
            Object result = conn.executeCommand(this.command);
            if (result != null) {
                this.handleExceptionFromRemoteExecution(conn, (String)result);
            }
        }
        catch (CommunicationException comEx) {
            this.handleCommunicationException(conn, comEx);
        }
    }

    public void handleExceptionFromRemoteExecution(RemoteConnection conn, String exString) {
        Object[] args = new Object[]{conn.getServiceId(), exString};
        this.rcm.logWarning("failed_command_propagation", args);
        RemoteCommandManagerException rcmException = RemoteCommandManagerException.unableToPropagateCommand(conn.toString(), new Exception(exString));
        this.rcm.handleException(rcmException);
    }

    public void handleCommunicationException(RemoteConnection conn, CommunicationException comEx) {
        block4: {
            if (this.rcm.getTransportManager().shouldRemoveConnectionOnError()) {
                Object[] args = new Object[]{conn.getServiceId(), comEx.getInternalException()};
                this.rcm.logWarning("drop_connection_on_error", args);
                this.rcm.getTransportManager().removeConnectionToExternalService(conn);
            } else {
                Object[] args = new Object[]{conn.getServiceId(), comEx};
                this.rcm.logWarning("failed_command_propagation", args);
                RemoteCommandManagerException rcmException = RemoteCommandManagerException.unableToPropagateCommand(conn.toString(), comEx.getInternalException());
                try {
                    this.rcm.handleException(rcmException);
                }
                catch (RuntimeException ex) {
                    if (this.connection != null) break block4;
                    throw ex;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block2: {
            block1: {
                if (this.connection == null) break block1;
                this.propagateCommand(this.connection);
                break block2;
            }
            mapConnections = this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation();
            enumConnections = mapConnections.elements();
            if (mapConnections.size() != 1) ** GOTO lbl14
            this.connection = (RemoteConnection)enumConnections.nextElement();
            this.propagateCommand(this.connection);
            break block2;
lbl-1000:
            // 1 sources

            {
                conn = (RemoteConnection)enumConnections.nextElement();
                propagator = new CommandPropagator(this.rcm, this.command, conn);
                this.rcm.getServerPlatform().launchContainerRunnable(propagator);
lbl14:
                // 2 sources

                ** while (enumConnections.hasMoreElements())
            }
        }
    }
}

