/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;

public class ExceptionMessageGenerator {
    public static ClassLoader getLoader() {
        ClassLoader loader = ExceptionMessageGenerator.class.getClassLoader();
        if (loader == null) {
            loader = ConversionManager.getDefaultManager().getLoader();
        }
        return loader;
    }

    public static String buildMessage(Class exceptionClass, int errorNumber, Object[] arguments) {
        String CR = System.getProperty("line.separator");
        String shortClassName = Helper.getShortClassName(exceptionClass);
        String message = "";
        ResourceBundle bundle2 = null;
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "null";
            }
            ++i;
        }
        bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n." + shortClassName + "Resource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
        try {
            message = bundle2.getString(String.valueOf(errorNumber));
        }
        catch (MissingResourceException missingResourceException) {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            String noTranslationMessage = bundle2.getString("NoExceptionTranslationForThisLocale");
            Object[] args = new Object[]{CR};
            return String.valueOf(ExceptionMessageGenerator.format(message, arguments)) + ExceptionMessageGenerator.format(noTranslationMessage, args);
        }
        return ExceptionMessageGenerator.format(message, arguments);
    }

    /*
     * Unable to fully structure code
     */
    protected static String format(String message, Object[] arguments) {
        block5: {
            try {
                return MessageFormat.format(message, arguments);
            }
            catch (Exception v0) {
                bundle = null;
                bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
                errorMessage = bundle.getString("ErrorFormattingMessage");
                vec = new Vector<Object>();
                if (arguments == null) break block5;
                index = 0;
                ** while (index < arguments.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    vec.add(arguments[index].toString());
                }
                catch (Exception ex2) {
                    vec.add(ex2);
                }
                ++index;
                continue;
            }
        }
        return MessageFormat.format(errorMessage, new Object[]{message, vec});
    }

    public static String getHeader(String headerLabel) {
        ResourceBundle bundle2 = null;
        try {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            return bundle2.getString(headerLabel);
        }
        catch (MissingResourceException missingResourceException) {
            return "[" + headerLabel + "]";
        }
    }
}

