/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.filter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.PropertiesHelper;

@Provider
public class HttpDigestAuthFilter
implements ClientRequestFilter,
ClientResponseFilter {
    @Inject
    private Configuration config;
    private static final Logger logger = Logger.getLogger(HttpDigestAuthFilter.class.getName());
    private static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");
    private static final String HEADER_DIGEST_SCHEME = "jersey-digest-filter-digest-scheme";
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern KEY_VALUE_PAIR_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(\"([^\"]+)\"|(\\w+))\\s*,?\\s*");
    private static final int CLIENT_NONCE_BYTE_COUNT = 4;
    private static final int MAXIMUM_DIGEST_CACHE_SIZE = 1000;
    private final SecureRandom randomGenerator;
    private final String username;
    private final byte[] password;
    private final Map<URI, DigestScheme> digestCache;

    public HttpDigestAuthFilter(String username, String password) {
        this(username, password != null ? password.getBytes(CHARACTER_SET) : new byte[]{});
    }

    private HttpDigestAuthFilter(String username, byte[] password) {
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = new byte[]{};
        }
        this.username = username;
        this.password = password;
        int limit = 1000;
        if (this.config != null && (limit = PropertiesHelper.getValue(this.config.getProperties(), "jersey.config.client.digestAuthUriCacheSizeLimit", 1000).intValue()) < 1) {
            limit = 1000;
        }
        final int mapSize = limit;
        this.digestCache = Collections.synchronizedMap(new LinkedHashMap<URI, DigestScheme>(mapSize){
            private static final long serialVersionUID = 2546245625L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > mapSize;
            }
        });
        try {
            this.randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_DIGEST_FILTER_GENERATOR(), e);
        }
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        List digestSchemeHeaders = (List)requestContext.getHeaders().get(HEADER_DIGEST_SCHEME);
        DigestScheme digestScheme = null;
        if (digestSchemeHeaders != null && digestSchemeHeaders.size() > 0) {
            Object digestHeaderObject = digestSchemeHeaders.get(0);
            if (digestHeaderObject instanceof DigestScheme) {
                digestScheme = (DigestScheme)digestHeaderObject;
            }
            requestContext.getHeaders().remove(HEADER_DIGEST_SCHEME);
        }
        if (digestScheme == null) {
            digestScheme = this.digestCache.get(requestContext.getUri());
        }
        if (digestScheme != null) {
            String authLine = this.createNextAuthToken(digestScheme, requestContext);
            requestContext.getHeaders().add("Authorization", authLine);
        }
        if (logger.isLoggable(Level.FINEST) && requestContext.getHeaderString("Authorization") != null) {
            logger.log(Level.FINEST, "Client Request: {0}", requestContext.getHeaderString("Authorization"));
        }
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (logger.isLoggable(Level.FINEST) && responseContext.getHeaderString("WWW-Authenticate") != null) {
            logger.log(Level.FINEST, "Server Response: {0} {1}", new Object[]{responseContext.getStatus(), responseContext.getHeaderString("WWW-Authenticate")});
        }
        if (Response.Status.fromStatusCode(responseContext.getStatus()) == Response.Status.UNAUTHORIZED) {
            DigestScheme digestScheme = this.parseAuthHeaders((List)responseContext.getHeaders().get("WWW-Authenticate"));
            if (digestScheme == null) {
                return;
            }
            if (digestScheme.isStale() || !this.digestCache.containsKey(requestContext.getUri())) {
                this.digestCache.put(requestContext.getUri(), digestScheme);
                Client client = requestContext.getClient();
                String method = requestContext.getMethod();
                MediaType mediaType = requestContext.getMediaType();
                URI lUri = requestContext.getUri();
                WebTarget resourceTarget = client.target(lUri);
                Invocation.Builder builder = resourceTarget.request(mediaType);
                builder.headers(requestContext.getHeaders());
                builder.header(HEADER_DIGEST_SCHEME, digestScheme);
                Invocation invocation = builder.build(method);
                Response nextResponse = invocation.invoke();
                if (nextResponse == null) {
                    return;
                }
                if (nextResponse.hasEntity()) {
                    responseContext.setEntityStream(nextResponse.readEntity(InputStream.class));
                }
                MultivaluedMap<String, String> headers = responseContext.getHeaders();
                headers.clear();
                headers.putAll(nextResponse.getStringHeaders());
                responseContext.setStatus(nextResponse.getStatus());
            }
        }
    }

    private DigestScheme parseAuthHeaders(List<?> headers) throws IOException {
        if (headers == null) {
            return null;
        }
        for (Object lineObject : headers) {
            String line;
            String[] parts;
            if (!(lineObject instanceof String) || (parts = (line = (String)lineObject).trim().split("\\s+", 2)).length != 2 || !parts[0].toLowerCase().equals("digest")) continue;
            String realm = null;
            String nonce = null;
            String opaque = null;
            QOP qop = QOP.UNSPECIFIED;
            Algorithm algorithm = Algorithm.UNSPECIFIED;
            boolean stale = false;
            Matcher match = KEY_VALUE_PAIR_PATTERN.matcher(parts[1]);
            while (match.find()) {
                String val;
                int nbGroups = match.groupCount();
                if (nbGroups != 4) continue;
                String key = match.group(1);
                String valNoQuotes = match.group(3);
                String valQuotes = match.group(4);
                String string = val = valNoQuotes == null ? valQuotes : valNoQuotes;
                if (key.equals("qop")) {
                    qop = QOP.parse(val);
                    continue;
                }
                if (key.equals("realm")) {
                    realm = val;
                    continue;
                }
                if (key.equals("nonce")) {
                    nonce = val;
                    continue;
                }
                if (key.equals("opaque")) {
                    opaque = val;
                    continue;
                }
                if (key.equals("stale")) {
                    stale = Boolean.parseBoolean(val);
                    continue;
                }
                if (!key.equals("algorithm")) continue;
                algorithm = Algorithm.parse(val);
            }
            return new DigestScheme(realm, nonce, opaque, qop, algorithm, stale);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createNextAuthToken(DigestScheme ds, ClientRequestContext requestContext) throws IOException {
        String response;
        String ha2;
        StringBuilder sb = new StringBuilder(100);
        sb.append("Digest ");
        HttpDigestAuthFilter.append(sb, "username", this.username);
        HttpDigestAuthFilter.append(sb, "realm", ds.getRealm());
        HttpDigestAuthFilter.append(sb, "nonce", ds.getNonce());
        HttpDigestAuthFilter.append(sb, "opaque", ds.getOpaque());
        HttpDigestAuthFilter.append(sb, "algorithm", ds.getAlgorithm().toString(), false);
        HttpDigestAuthFilter.append(sb, "qop", ds.getQop().toString(), false);
        String uri = requestContext.getUri().getRawPath();
        HttpDigestAuthFilter.append(sb, "uri", uri);
        String ha1 = ds.getAlgorithm().equals((Object)Algorithm.MD5_SESS) ? HttpDigestAuthFilter.md5(HttpDigestAuthFilter.md5(this.username, ds.getRealm(), new String(this.password))) : HttpDigestAuthFilter.md5(this.username, ds.getRealm(), new String(this.password));
        if (ds.getQop() == QOP.AUTH_INT && requestContext.hasEntity()) {
            Object entity = requestContext.getEntity();
            if (!(entity instanceof String)) throw new IOException("Entity of class " + entity.getClass().toString() + " not supported");
            ha2 = HttpDigestAuthFilter.md5(requestContext.getMethod(), uri, HttpDigestAuthFilter.md5((String)entity));
        } else {
            ha2 = HttpDigestAuthFilter.md5(requestContext.getMethod(), uri);
        }
        if (ds.getQop().equals((Object)QOP.UNSPECIFIED)) {
            response = HttpDigestAuthFilter.md5(ha1, ds.getNonce(), ha2);
        } else {
            String cnonce = this.randomBytes(4);
            HttpDigestAuthFilter.append(sb, "cnonce", cnonce);
            String nc = String.format("%08x", ds.incrementCounter());
            HttpDigestAuthFilter.append(sb, "nc", nc, false);
            response = HttpDigestAuthFilter.md5(ha1, ds.getNonce(), nc, cnonce, ds.getQop().toString(), ha2);
        }
        HttpDigestAuthFilter.append(sb, "response", response);
        return sb.toString();
    }

    private static void append(StringBuilder sb, String key, String value, boolean useQuote) {
        if (value == null) {
            return;
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(',');
        }
        sb.append(key);
        sb.append('=');
        if (useQuote) {
            sb.append('\"');
        }
        sb.append(value);
        if (useQuote) {
            sb.append('\"');
        }
    }

    private static void append(StringBuilder sb, String key, String value) {
        HttpDigestAuthFilter.append(sb, key, value, true);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String md5(String ... tokens) throws IOException {
        MessageDigest md;
        StringBuilder sb = new StringBuilder(100);
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(token);
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex.getMessage());
        }
        md.update(sb.toString().getBytes(CHARACTER_SET), 0, sb.length());
        byte[] md5hash = md.digest();
        return HttpDigestAuthFilter.bytesToHex(md5hash);
    }

    private String randomBytes(int nbBytes) {
        byte[] bytes = new byte[nbBytes];
        this.randomGenerator.nextBytes(bytes);
        return HttpDigestAuthFilter.bytesToHex(bytes);
    }

    final class DigestScheme {
        private final String realm;
        private final String nonce;
        private final String opaque;
        private final Algorithm algorithm;
        private final QOP qop;
        private final boolean stale;
        private volatile int nc;

        public DigestScheme(String realm, String nonce, String opaque, QOP qop, Algorithm algorithm, boolean stale) {
            this.realm = realm;
            this.nonce = nonce;
            this.opaque = opaque;
            this.qop = qop;
            this.algorithm = algorithm;
            this.stale = stale;
            this.nc = 0;
        }

        public int incrementCounter() {
            return this.nc++;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getOpaque() {
            return this.opaque;
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public QOP getQop() {
            return this.qop;
        }

        public boolean isStale() {
            return this.stale;
        }

        public int getNc() {
            return this.nc;
        }
    }

    private static enum Algorithm {
        UNSPECIFIED(null),
        MD5("md5"),
        MD5_SESS("md5-sess");

        private final String md;

        private Algorithm(String md) {
            this.md = md;
        }

        public String toString() {
            return this.md;
        }

        public static Algorithm parse(String val) {
            if (val == null || val.isEmpty()) {
                return UNSPECIFIED;
            }
            if ((val = val.trim()).contains("md5-sess")) {
                return MD5_SESS;
            }
            return MD5;
        }
    }

    private static enum QOP {
        UNSPECIFIED(null),
        AUTH("auth"),
        AUTH_INT("auth-int");

        private final String qop;

        private QOP(String qop) {
            this.qop = qop;
        }

        public String toString() {
            return this.qop;
        }

        public static QOP parse(String val) {
            if (val == null || val.isEmpty()) {
                return UNSPECIFIED;
            }
            if (val.contains("auth-int")) {
                return AUTH_INT;
            }
            return AUTH;
        }
    }
}

