/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class DpsTask
implements Serializable {
    public static final String DATASETS = "DATASETS";
    public static final String FILE_URLS = "FILE_URLS";
    private Map<String, List<String>> inputData;
    private Map<String, String> parameters;
    private Date startTime = null;
    private Date createTime = new Date(System.currentTimeMillis());
    private Date endTime = null;
    private long taskId;
    private String taskName;

    public DpsTask() {
        this("");
    }

    public DpsTask(String taskName) {
        this.taskName = taskName;
        this.inputData = new HashMap<String, List<String>>();
        this.parameters = new HashMap<String, String>();
        this.taskId = UUID.randomUUID().getMostSignificantBits();
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void addDataEntry(String dataType, List<String> data) {
        this.inputData.put(dataType, data);
    }

    public List<String> getDataEntry(String dataType) {
        return this.inputData.get(dataType);
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public String getParameter(String parameterKey) {
        return this.parameters.get(parameterKey);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, List<String>> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, List<String>> inputData) {
        this.inputData = inputData;
    }
}

