/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.dps.rest;

import eu.europeana.cloud.service.dps.DpsTask;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsClient {
    private Logger LOGGER = LoggerFactory.getLogger(DpsClient.class);
    private String dpsUrl;
    private Client client = JerseyClientBuilder.newClient();
    private static final String TOPOLOGY_NAME = "TopologyName";
    private static final String TASK_ID = "TaskId";
    private static final String TASKS_URL = "/topologies/{TopologyName}/tasks";
    private static final String TASK_URL = "/topologies/{TopologyName}/tasks/{TaskId}";
    public static final String TASK_PROGRESS_URL = "/topologies/{TopologyName}/tasks/{TaskId}/progress";
    public static final String TASK_NOTIFICATION_URL = "/topologies/{TopologyName}/tasks/{TaskId}/notification";

    public DpsClient(String dpsUrl, String username, String password) {
        this.client.register(new HttpBasicAuthFilter(username, password));
        this.dpsUrl = dpsUrl;
    }

    public void submitTask(DpsTask task, String topologyName) {
        Response resp = this.client.target(this.dpsUrl).path(TASKS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).request().post(Entity.json(task));
        if (resp.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new RuntimeException("submiting taks failed!!");
        }
    }

    public DpsTask getTask(String topologyName, long taskId) {
        Response getResponse = this.client.target(this.dpsUrl).path(TASK_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, String.valueOf(taskId)).request().header("Accept", "application/json").get();
        if (getResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            DpsTask task = getResponse.readEntity(DpsTask.class);
            return task;
        }
        throw new RuntimeException();
    }

    public String getTaskProgress(String topologyName, long taskId) {
        Response getResponse = this.client.target(this.dpsUrl).path(TASK_PROGRESS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get();
        if (getResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            String taskProgress = getResponse.readEntity(String.class);
            return taskProgress;
        }
        this.LOGGER.error("Task progress cannot be read");
        throw new RuntimeException();
    }

    public String getTaskNotification(String topologyName, long taskId) {
        Response getResponse = this.client.target(this.dpsUrl).path(TASK_NOTIFICATION_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get();
        if (getResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            String taskProgress = getResponse.readEntity(String.class);
            return taskProgress;
        }
        this.LOGGER.error("Task notification cannot be read");
        throw new RuntimeException();
    }
}

