/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;

public class CassandraReportService
implements TaskExecutionReportService {
    CassandraConnectionProvider cassandra;

    public CassandraReportService(String hosts, int port, String keyspaceName, String userName, String password) {
        this.cassandra = new CassandraConnectionProvider(hosts, port, keyspaceName, userName, password);
    }

    public String getTaskProgress(String taskId) throws AccessDeniedOrObjectDoesNotExistException {
        long taskId_ = Long.valueOf(taskId);
        JsonObject res = new JsonObject();
        res.addProperty("taskId", (Number)taskId_);
        Select.Where selectFromBasicInfo = QueryBuilder.select().all().from("basic_info").where(QueryBuilder.eq((String)"task_id", (Object)taskId_));
        Row basicInfo = this.cassandra.getSession().execute((Statement)selectFromBasicInfo).one();
        long processed = 0L;
        if (basicInfo != null) {
            int expectedSize = basicInfo.getInt("expected_size");
            if (expectedSize > 0) {
                Select selectFromNotification = QueryBuilder.select().countAll().from("notifications").where(QueryBuilder.eq((String)"task_id", (Object)taskId_)).limit(expectedSize);
                ResultSet notifications = this.cassandra.getSession().execute((Statement)selectFromNotification);
                processed = notifications.one().getLong("count");
            }
            res.addProperty("topologyName", basicInfo.getString("topology_name"));
            res.addProperty("totalSize", (Number)expectedSize);
            res.addProperty("processed", (Number)processed);
            res.addProperty("state", basicInfo.getString("state"));
            res.addProperty("info", basicInfo.getString("info"));
        } else {
            Select.Where selectFromNotification = QueryBuilder.select().countAll().from("notifications").where(QueryBuilder.eq((String)"task_id", (Object)taskId_));
            ResultSet notifications = this.cassandra.getSession().execute((Statement)selectFromNotification);
            processed = notifications.one().getLong("count");
            res.addProperty("topologyName", "");
            res.addProperty("totalSize", "?");
            res.addProperty("processed", (Number)processed);
            res.addProperty("state", "");
            res.addProperty("info", "");
        }
        return new Gson().toJson((JsonElement)res);
    }

    public String getTaskNotification(String taskId) {
        Select.Where selectFromNotification = QueryBuilder.select().all().from("notifications").where(QueryBuilder.eq((String)"task_id", (Object)Long.valueOf(taskId)));
        ResultSet notifications = this.cassandra.getSession().execute((Statement)selectFromNotification);
        return new Gson().toJson((JsonElement)this.notificationResultsetToJsonObject(notifications));
    }

    public void incrTaskProgress(String taskId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private JsonArray notificationResultsetToJsonObject(ResultSet data) {
        JsonArray res = new JsonArray();
        for (Row row : data) {
            JsonObject line = new JsonObject();
            line.addProperty("task_id", (Number)row.getLong("task_id"));
            line.addProperty("topology_name", row.getString("topology_name"));
            line.addProperty("resource", row.getString("resource"));
            line.addProperty("state", row.getString("state"));
            line.addProperty("info_text", row.getString("info_text"));
            line.addProperty("additional_informations", row.getString("additional_informations"));
            line.addProperty("result_resource", row.getString("result_resource"));
            res.add((JsonElement)line);
        }
        return res;
    }
}

