/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.utils;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import eu.europeana.cloud.common.utils.Bucket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BucketsHandler {
    public static final String OBJECT_ID_COLUMN_NAME = "object_id";
    public static final String BUCKET_ID_COLUMN_NAME = "bucket_id";
    public static final String ROWS_COUNT_COLUMN_NAME = "rows_count";
    private Session session;

    public BucketsHandler(Session session) {
        this.session = session;
    }

    public Bucket getCurrentBucket(String bucketsTableName, String objectId) {
        Row row;
        String query = "SELECT object_id, bucket_id, rows_count FROM " + bucketsTableName + " WHERE object_id = '" + objectId + "';";
        ResultSet rs = this.session.execute(query);
        List rows = rs.all();
        Row row2 = row = rows.isEmpty() ? null : (Row)rows.get(rows.size() - 1);
        if (row != null) {
            return new Bucket(row.getString(OBJECT_ID_COLUMN_NAME), row.getUUID(BUCKET_ID_COLUMN_NAME).toString(), row.getLong(ROWS_COUNT_COLUMN_NAME));
        }
        return null;
    }

    public void increaseBucketCount(String bucketsTableName, Bucket bucket) {
        String query = "UPDATE " + bucketsTableName + " SET rows_count = rows_count + 1 WHERE object_id = '" + bucket.getObjectId() + "' AND bucket_id = " + UUID.fromString(bucket.getBucketId()) + ";";
        this.session.execute(query);
    }

    public void decreaseBucketCount(String bucketsTableName, Bucket bucket) {
        String query = "UPDATE " + bucketsTableName + " SET rows_count = rows_count - 1 WHERE object_id = '" + bucket.getObjectId() + "' AND bucket_id = " + UUID.fromString(bucket.getBucketId()) + ";";
        this.session.execute(query);
        Bucket actual = this.getBucket(bucketsTableName, bucket);
        if (actual != null && actual.getRowsCount() == 0L) {
            this.removeBucket(bucketsTableName, bucket);
        }
    }

    public List<Bucket> getAllBuckets(String bucketsTableName, String objectId) {
        String query = "SELECT * FROM " + bucketsTableName + " WHERE object_id = '" + objectId + "';";
        ResultSet rs = this.session.execute(query);
        ArrayList<Bucket> resultBuckets = new ArrayList<Bucket>();
        List rows = rs.all();
        for (Row row : rows) {
            Bucket bucket = new Bucket(row.getString(OBJECT_ID_COLUMN_NAME), row.getUUID(BUCKET_ID_COLUMN_NAME).toString(), row.getLong(ROWS_COUNT_COLUMN_NAME));
            resultBuckets.add(bucket);
        }
        return resultBuckets;
    }

    public Bucket getBucket(String bucketsTableName, Bucket bucket) {
        String query = "SELECT * FROM " + bucketsTableName + " where object_id = '" + bucket.getObjectId() + "' AND bucket_id = " + UUID.fromString(bucket.getBucketId()) + " LIMIT 1;";
        return this.getBucket(query);
    }

    public Bucket getNextBucket(String bucketsTableName, String objectId) {
        String query = "SELECT * FROM " + bucketsTableName + " where object_id = '" + objectId + "' LIMIT 1;";
        return this.getBucket(query);
    }

    public Bucket getNextBucket(String bucketsTableName, String objectId, Bucket bucket) {
        String query = "SELECT * FROM " + bucketsTableName + " where object_id = '" + objectId + "' AND bucket_id > " + UUID.fromString(bucket.getBucketId()) + " LIMIT 1;";
        return this.getBucket(query);
    }

    public void removeBucket(String bucketsTableName, Bucket bucket) {
        String query = "DELETE FROM " + bucketsTableName + " WHERE object_id = '" + bucket.getObjectId() + "' AND bucket_id = " + UUID.fromString(bucket.getBucketId()) + ";";
        this.session.execute(query);
    }

    private Bucket getBucket(String query) {
        ResultSet rs = this.session.execute(query);
        Row row = rs.one();
        Bucket resultBucket = null;
        if (row != null) {
            resultBucket = new Bucket(row.getString(OBJECT_ID_COLUMN_NAME), row.getUUID(BUCKET_ID_COLUMN_NAME).toString(), row.getLong(ROWS_COUNT_COLUMN_NAME));
        }
        return resultBucket;
    }
}

