/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.logging;

import eu.europeana.cloud.service.commons.logging.LoggingMessage;
import eu.europeana.cloud.service.commons.logging.LoggingMessageBuilder;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
public class LoggingFilter
implements ContainerResponseFilter,
ContainerRequestFilter {
    @Context
    HttpServletRequest httpRequest;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);
    private StringBuilder logMessageBuilder;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.publishRequestStartTimeTo(requestContext);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        LoggingMessage message = this.buildMessage(requestContext, responseContext);
        switch (message.getStatus()) {
            case 404: 
            case 409: {
                LOGGER.warn(message.getMessage());
                break;
            }
            default: {
                LOGGER.info(message.getMessage());
            }
        }
    }

    private void publishRequestStartTimeTo(ContainerRequestContext requestContext) {
        long requestStartTime = System.currentTimeMillis();
        requestContext.setProperty("startTime", (Object)requestStartTime);
    }

    private LoggingMessage buildMessage(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        LoggingMessageBuilder builder = new LoggingMessageBuilder();
        LoggingMessage message = builder.withStatusCode(responseContext.getStatus()).withRemoteAddr(this.readRemoteAddr()).withRequestTime(this.calculateRequestTime(requestContext)).withResourcePath(this.readRequestPath(requestContext)).withRequestMethod(this.readRequestMethod(requestContext)).build();
        return message;
    }

    private String readRemoteAddr() {
        try {
            return this.httpRequest.getRemoteAddr();
        }
        catch (Exception e) {
            return "error.remote.address";
        }
    }

    private long calculateRequestTime(ContainerRequestContext requestContext) {
        long now = System.currentTimeMillis();
        long requestTime = now - (Long)requestContext.getProperty("startTime");
        return requestTime;
    }

    private String readRequestPath(ContainerRequestContext requestContext) {
        return requestContext.getUriInfo().getPath().replaceAll(" ", "%20");
    }

    private String readRequestMethod(ContainerRequestContext requestContext) {
        return requestContext.getMethod();
    }
}

