/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.urls;

import eu.europeana.cloud.service.commons.urls.UrlBuilderException;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.commons.urls.ValuedUrlPart;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UrlBuilder {
    private Map<UrlPart, String> parts;
    private Set<ValuedUrlPart> partsToInclude = new HashSet<ValuedUrlPart>();

    UrlBuilder(Map<UrlPart, String> parts) {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.CONTEXT, true));
        this.parts = parts;
    }

    public UrlBuilder clear() {
        this.partsToInclude = new HashSet<ValuedUrlPart>();
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.CONTEXT, true));
        return this;
    }

    public UrlBuilder withCloudID() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.RECORDS, true));
        return this;
    }

    public UrlBuilder withRepresentation() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.REPRESENTATIONS, true));
        return this;
    }

    public UrlBuilder withVersion() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.VERSIONS, true));
        return this;
    }

    public UrlBuilder withVersionWithoutValue() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.VERSIONS, false));
        return this;
    }

    public UrlBuilder withDataProvider() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_PROVIDERS, true));
        return this;
    }

    public UrlBuilder withDataSet() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_SETS, true));
        return this;
    }

    public UrlBuilder withDataSetWithoutValue() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_SETS, false));
        return this;
    }

    public String build() throws UrlBuilderException {
        String result = "";
        for (Map.Entry<UrlPart, String> entry : this.parts.entrySet()) {
            ValuedUrlPart key = new ValuedUrlPart(entry.getKey(), true);
            String value = entry.getValue();
            if (!this.shouldBeIncludedInResult(entry.getKey())) continue;
            ValuedUrlPart currentPart = this.removeFromPartsToInclude(entry.getKey());
            if (currentPart.isAddValue()) {
                if (value != null) {
                    if ("".equals(key.getPart().getValue())) {
                        result = result + "/" + value;
                        continue;
                    }
                    result = result + "/" + key.getPart().getValue() + "/" + value;
                    continue;
                }
                throw new UrlBuilderException("Value for: " + key + " is empty");
            }
            result = result + "/" + key.getPart().getValue();
        }
        if (this.partsToInclude.size() > 0) {
            String errorMessage = this.createErrorMessage(this.partsToInclude);
            throw new UrlBuilderException("Missing parts for given request: " + errorMessage);
        }
        return result;
    }

    private boolean shouldBeIncludedInResult(UrlPart urlPart) {
        Iterator<ValuedUrlPart> it = this.partsToInclude.iterator();
        while (it.hasNext()) {
            if (!it.next().getPart().equals((Object)urlPart)) continue;
            return true;
        }
        return false;
    }

    private ValuedUrlPart removeFromPartsToInclude(UrlPart urlPart) {
        Iterator<ValuedUrlPart> it = this.partsToInclude.iterator();
        while (it.hasNext()) {
            ValuedUrlPart currentPart = it.next();
            if (!currentPart.getPart().equals((Object)urlPart)) continue;
            it.remove();
            return currentPart;
        }
        return null;
    }

    private String createErrorMessage(Set<ValuedUrlPart> leftParts) {
        String result = "";
        for (ValuedUrlPart leftPart : leftParts) {
            result = result + (Object)((Object)leftPart.getPart()) + " ";
        }
        return result;
    }
}

