/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.rest;

import eu.europeana.cloud.common.model.User;
import eu.europeana.cloud.service.aas.authentication.AuthenticationService;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidPasswordException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidUsernameException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class AuthenticationResource {
    @Autowired
    private AuthenticationService authenticationService;

    @PostMapping(value={"/create-user"}, produces={"application/json", "application/xml"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ResponseEntity<String> createCloudUser(@RequestParam(value="username") String username, @RequestParam(value="password") String password) throws DatabaseConnectionException, UserExistsException, InvalidUsernameException, InvalidPasswordException {
        this.authenticationService.createUser(new User(username, password));
        return ResponseEntity.ok((Object)"Cloud user was created!");
    }

    @PostMapping(value={"/delete-user"}, produces={"application/json", "application/xml"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ResponseEntity<String> deleteCloudUser(@RequestParam(value="username") String username) throws DatabaseConnectionException, UserDoesNotExistException {
        this.authenticationService.deleteUser(username);
        return ResponseEntity.ok((Object)"Cloud user is gone. Bye bye.");
    }

    @PostMapping(value={"/update-user"}, produces={"application/json", "application/xml"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ResponseEntity<String> updateCloudUser(@RequestParam(value="username") String username, @RequestParam(value="password") String password) throws DatabaseConnectionException, UserDoesNotExistException, InvalidPasswordException {
        this.authenticationService.updateUser(new User(username, password));
        return ResponseEntity.ok((Object)"Cloud user updated.");
    }
}

