/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.config;

import eu.europeana.cloud.common.exceptions.GenericException;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidPasswordException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidUsernameException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Order(value=-2147483648)
@ControllerAdvice(basePackages={"eu.europeana.cloud.service.aas.rest"})
public class UnifiedExceptionsMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedExceptionsMapper.class);

    @ExceptionHandler(value={DatabaseConnectionException.class, InvalidUsernameException.class, InvalidPasswordException.class, UserExistsException.class, UserDoesNotExistException.class})
    public ResponseEntity<ErrorInfo> handleException(GenericException e) {
        LOGGER.info("Exception handling fired");
        return this.buildResponse(e);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ErrorInfo> handleAccessDeniedException(AccessDeniedException e) {
        LOGGER.error("Exception handling fired for ", (Throwable)e);
        return ResponseEntity.status((int)HttpStatus.METHOD_NOT_ALLOWED.value()).body((Object)new ErrorInfo("OTHER", e.getMessage()));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ErrorInfo> handle(RuntimeException e) {
        LOGGER.error("Exception handling fired for ", (Throwable)e);
        return ResponseEntity.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).body((Object)new ErrorInfo("OTHER", e.getMessage()));
    }

    private ResponseEntity<ErrorInfo> buildResponse(GenericException e) {
        return ResponseEntity.status((int)e.getErrorInfo().getHttpCode().getStatusCode()).body((Object)e.getErrorInfo().getErrorInfo());
    }
}

