/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.config;

import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.service.aas.LoggingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
@ComponentScan(value={"eu.europeana.cloud.service.aas"})
public class ServiceConfiguration
implements WebMvcConfigurer {
    public static final String JNDI_KEY_AAS_CASSANDRA_HOSTS = "/aas/cassandra/hosts";
    public static final String JNDI_KEY_AAS_CASSANDRA_PORT = "/aas/cassandra/port";
    public static final String JNDI_KEY_AAS_CASSANDRA_AUTHENTICATION_KEYSPACE = "/aas/cassandra/authentication-keyspace";
    public static final String JNDI_KEY_AAS_CASSANDRA_USERNAME = "/aas/cassandra/user";
    public static final String JNDI_KEY_AAS_CASSANDRA_PASSWORD = "/aas/cassandra/password";
    private final Environment environment;

    public ServiceConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    public CassandraConnectionProvider aasCassandraProvider() {
        String hosts = this.environment.getProperty(JNDI_KEY_AAS_CASSANDRA_HOSTS);
        Integer port = (Integer)this.environment.getProperty(JNDI_KEY_AAS_CASSANDRA_PORT, Integer.class);
        String keyspaceName = this.environment.getProperty(JNDI_KEY_AAS_CASSANDRA_AUTHENTICATION_KEYSPACE);
        String userName = this.environment.getProperty(JNDI_KEY_AAS_CASSANDRA_USERNAME);
        String password = this.environment.getProperty(JNDI_KEY_AAS_CASSANDRA_PASSWORD);
        return new CassandraConnectionProvider(hosts, port.intValue(), keyspaceName, userName, password);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new LoggingFilter());
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        return new MethodValidationPostProcessor();
    }
}

