/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas;

import eu.europeana.cloud.service.commons.logging.LoggingMessage;
import eu.europeana.cloud.service.commons.logging.LoggingMessageBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoggingFilter
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);

    public boolean preHandle(HttpServletRequest servletRequest, HttpServletResponse hsr1, Object handler) {
        this.publishRequestStartTimeTo(servletRequest);
        return true;
    }

    public void afterCompletion(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler, Exception excptn) {
        LoggingMessage message = this.buildMessage(servletRequest, servletResponse);
        switch (message.getStatus()) {
            case 404: 
            case 409: {
                LOGGER.warn(message.getMessage());
                break;
            }
            default: {
                LOGGER.info(message.getMessage());
            }
        }
    }

    private void publishRequestStartTimeTo(HttpServletRequest servletRequest) {
        long requestStartTime = System.currentTimeMillis();
        servletRequest.setAttribute("startTime", (Object)requestStartTime);
    }

    private LoggingMessage buildMessage(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        LoggingMessageBuilder builder = new LoggingMessageBuilder();
        return builder.withStatusCode(servletResponse.getStatus()).withRemoteAddr(this.readRemoteAddr(servletRequest)).withRequestTime(this.calculateRequestTime(servletRequest)).withResourcePath(this.readRequestPath(servletRequest)).withRequestMethod(this.readRequestMethod(servletRequest)).build();
    }

    private String readRemoteAddr(HttpServletRequest servletRequest) {
        try {
            return servletRequest.getRemoteAddr();
        }
        catch (Exception e) {
            return "error.remote.address";
        }
    }

    private long calculateRequestTime(HttpServletRequest servletRequest) {
        long now = System.currentTimeMillis();
        return now - (Long)servletRequest.getAttribute("startTime");
    }

    private String readRequestPath(HttpServletRequest servletRequest) {
        return servletRequest.getRequestURI();
    }

    private String readRequestMethod(HttpServletRequest servletRequest) {
        return servletRequest.getMethod();
    }
}

