/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.aas.rest;

import eu.europeana.cloud.client.aas.rest.CloudException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASClient {
    private Client client = JerseyClientBuilder.newClient();
    private String aasUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(AASClient.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 20000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MILLIS = 60000;

    public AASClient(String aasUrl, String username, String password) {
        this(aasUrl, username, password, 20000, 60000);
    }

    public AASClient(String aasUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        LOGGER.info("AASClient starting...");
        this.client.register(HttpAuthenticationFeature.basic(username, password));
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        this.aasUrl = aasUrl;
        LOGGER.info("AASClient started successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEcloudUser(String username, String password) throws CloudException {
        Response resp = null;
        try {
            resp = this.client.target(this.aasUrl + "/create-user").queryParam("username", username).queryParam("password", password).request().post(null);
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeException("createEcloudUser() failed!");
            }
            LOGGER.debug("createEcloudUser: user {} is now part of ecloud", (Object)username);
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEcloudUser(String username, String password) throws CloudException {
        Response resp = null;
        try {
            resp = this.client.target(this.aasUrl + "/update-user").queryParam("username", username).queryParam("password", password).request().post(null);
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeException("updateEcloudUser() failed!");
            }
            LOGGER.debug("updateEcloudUser: user {} updated!", (Object)username);
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    public void deleteEcloudUser(String username) throws CloudException {
        Response resp = null;
        try {
            resp = this.client.target(this.aasUrl + "/delete-user").queryParam("username", username).request().post(null);
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeException("deleteEcloudUser() failed!");
            }
            LOGGER.debug("deleteEcloudUser: user {} deleted!", (Object)username);
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }

    public void close() {
        this.client.close();
    }
}

