/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodAdapter;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodMetadataReadingVisitor
extends MethodAdapter
implements MethodMetadata {
    private final String name;
    private final int access;
    private String declaringClassName;
    private final ClassLoader classLoader;
    private final MultiValueMap<String, MethodMetadata> methodMetadataMap;
    private final Map<String, Map<String, Object>> attributeMap = new LinkedHashMap<String, Map<String, Object>>(2);

    public MethodMetadataReadingVisitor(String name, int access, String declaringClassName, ClassLoader classLoader, MultiValueMap<String, MethodMetadata> methodMetadataMap) {
        super(new EmptyVisitor());
        this.name = name;
        this.access = access;
        this.declaringClassName = declaringClassName;
        this.classLoader = classLoader;
        this.methodMetadataMap = methodMetadataMap;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.methodMetadataMap.add(className, this);
        return new AnnotationAttributesReadingVisitor(className, this.attributeMap, null, this.classLoader);
    }

    @Override
    public String getMethodName() {
        return this.name;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && (this.access & 2) == 0;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributeMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.attributeMap.get(annotationType);
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }
}

