/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal.generators.resourcedoc;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ParamStyle;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.wadl.WadlGenerator;
import org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.glassfish.jersey.server.wadl.internal.WadlUtils;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.ResourceDocAccessor;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ClassDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.MethodDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ParamDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.RepresentationDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResourceDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResponseDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.WadlParamType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.xhtml.Elements;

public class WadlGeneratorResourceDocSupport
implements WadlGenerator {
    private WadlGenerator _delegate;
    private File _resourceDocFile;
    private InputStream _resourceDocStream;
    private ResourceDocAccessor _resourceDoc;
    @Context
    private Provider<SAXParserFactory> saxFactoryProvider;

    public WadlGeneratorResourceDocSupport() {
    }

    public WadlGeneratorResourceDocSupport(WadlGenerator wadlGenerator, ResourceDocType resourceDoc) {
        this._delegate = wadlGenerator;
        this._resourceDoc = new ResourceDocAccessor(resourceDoc);
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    public void setResourceDocFile(File resourceDocFile) {
        if (this._resourceDocStream != null) {
            throw new IllegalStateException("The resourceDocStream property is already set, therefore you cannot set the resourceDocFile property. Only one of both can be set at a time.");
        }
        this._resourceDocFile = resourceDocFile;
    }

    public void setResourceDocStream(InputStream resourceDocStream) {
        if (this._resourceDocStream != null) {
            throw new IllegalStateException("The resourceDocFile property is already set, therefore you cannot set the resourceDocStream property. Only one of both can be set at a time.");
        }
        this._resourceDocStream = resourceDocStream;
    }

    @Override
    public void init() throws Exception {
        if (this._resourceDocFile == null && this._resourceDocStream == null) {
            throw new IllegalStateException("Neither the resourceDocFile nor the resourceDocStream is set, one of both is required.");
        }
        this._delegate.init();
        ResourceDocType resourceDocType = WadlUtils.unmarshall(this._resourceDocFile != null ? new FileInputStream(this._resourceDocFile) : this._resourceDocStream, this.saxFactoryProvider.get(), ResourceDocType.class);
        this._resourceDoc = new ResourceDocAccessor(resourceDocType);
    }

    @Override
    public String getRequiredJaxbContextPath() {
        String name = Elements.class.getName();
        name = name.substring(0, name.lastIndexOf(46));
        return this._delegate.getRequiredJaxbContextPath() == null ? name : this._delegate.getRequiredJaxbContextPath() + ":" + name;
    }

    @Override
    public Application createApplication() {
        return this._delegate.createApplication();
    }

    @Override
    public Resource createResource(org.glassfish.jersey.server.model.Resource r, String path) {
        Resource result = this._delegate.createResource(r, path);
        for (Class<?> resourceClass : r.getHandlerClasses()) {
            ClassDocType classDoc = this._resourceDoc.getClassDoc(resourceClass);
            if (classDoc == null || this.isEmpty(classDoc.getCommentText())) continue;
            Doc doc = new Doc();
            doc.getContent().add(classDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Method createMethod(org.glassfish.jersey.server.model.Resource resource, ResourceMethod resourceMethod) {
        Method result = this._delegate.createMethod(resource, resourceMethod);
        java.lang.reflect.Method method = resourceMethod.getInvocable().getHandlingMethod();
        MethodDocType methodDoc = this._resourceDoc.getMethodDoc(method.getDeclaringClass(), method);
        if (methodDoc != null && !this.isEmpty(methodDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(methodDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Representation createRequestRepresentation(org.glassfish.jersey.server.model.Resource r, ResourceMethod m, MediaType mediaType) {
        Representation result = this._delegate.createRequestRepresentation(r, m, mediaType);
        RepresentationDocType requestRepresentation = this._resourceDoc.getRequestRepresentation(m.getInvocable().getHandlingMethod().getDeclaringClass(), m.getInvocable().getHandlingMethod(), result.getMediaType());
        if (requestRepresentation != null) {
            result.setElement(requestRepresentation.getElement());
            this.addDocForExample(result.getDoc(), requestRepresentation.getExample());
        }
        return result;
    }

    @Override
    public Request createRequest(org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        return this._delegate.createRequest(r, m);
    }

    @Override
    public List<Response> createResponses(org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        ResponseDocType responseDoc = this._resourceDoc.getResponse(m.getInvocable().getHandlingMethod().getDeclaringClass(), m.getInvocable().getHandlingMethod());
        ArrayList<Response> responses = new ArrayList();
        if (responseDoc != null && responseDoc.hasRepresentations()) {
            for (RepresentationDocType representationDoc : responseDoc.getRepresentations()) {
                Response response = new Response();
                Representation wadlRepresentation = new Representation();
                wadlRepresentation.setElement(representationDoc.getElement());
                wadlRepresentation.setMediaType(representationDoc.getMediaType());
                this.addDocForExample(wadlRepresentation.getDoc(), representationDoc.getExample());
                this.addDoc(wadlRepresentation.getDoc(), representationDoc.getDoc());
                response.getStatus().add(representationDoc.getStatus());
                response.getRepresentation().add(wadlRepresentation);
                responses.add(response);
            }
            if (!responseDoc.getWadlParams().isEmpty()) {
                for (WadlParamType wadlParamType : responseDoc.getWadlParams()) {
                    Param param = new Param();
                    param.setName(wadlParamType.getName());
                    param.setStyle(ParamStyle.fromValue(wadlParamType.getStyle()));
                    param.setType(wadlParamType.getType());
                    this.addDoc(param.getDoc(), wadlParamType.getDoc());
                    for (Response response : responses) {
                        response.getParam().add(param);
                    }
                }
            }
            if (!this.isEmpty(responseDoc.getReturnDoc())) {
                for (Response response : responses) {
                    this.addDoc(response.getDoc(), responseDoc.getReturnDoc());
                }
            }
        } else {
            responses = this._delegate.createResponses(r, m);
        }
        return responses;
    }

    private void addDocForExample(List<Doc> docs, String example) {
        if (!this.isEmpty(example)) {
            Doc doc = new Doc();
            Elements pElement = Elements.el("p").add(Elements.val("h6", "Example")).add(new Object[]{Elements.el("pre").add(Elements.val("code", example))});
            doc.getContent().add((Object)pElement);
            docs.add(doc);
        }
    }

    private void addDoc(List<Doc> docs, String text) {
        if (!this.isEmpty(text)) {
            Doc doc = new Doc();
            doc.getContent().add(text);
            docs.add(doc);
        }
    }

    @Override
    public Param createParam(org.glassfish.jersey.server.model.Resource r, ResourceMethod m, Parameter p) {
        ParamDocType paramDoc;
        Param result = this._delegate.createParam(r, m, p);
        if (result != null && (paramDoc = this._resourceDoc.getParamDoc(m.getInvocable().getHandlingMethod().getDeclaringClass(), m.getInvocable().getHandlingMethod(), p)) != null && !this.isEmpty(paramDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(paramDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0 || "".equals(text.trim());
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        return this._delegate.createExternalGrammar();
    }

    @Override
    public void attachTypes(ApplicationDescription egd) {
        this._delegate.attachTypes(egd);
    }
}

