/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ReaderInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;

class ReferencesInitializer
implements Function<ContainerRequest, ContainerRequest> {
    @Inject
    private ServiceLocator locator;
    @Inject
    private Provider<Ref<Request>> requestRefProvider;
    @Inject
    private Provider<Ref<ContainerRequest>> containerRequestRefProvider;
    @Inject
    private Provider<UriRoutingContext> uriRoutingCtxProvider;
    @Inject
    private Provider<Ref<UriInfo>> uriInfoRef;
    @Inject
    private Provider<Ref<HttpHeaders>> httpHeadersRef;
    @Inject
    private Provider<Ref<Request>> requestRef;

    ReferencesInitializer() {
    }

    @Override
    public ContainerRequest apply(ContainerRequest containerRequest) {
        this.requestRefProvider.get().set(containerRequest.getRequest());
        this.containerRequestRefProvider.get().set(containerRequest);
        RequestScopedInitializer requestScopedInitializer = containerRequest.getRequestScopedInitializer();
        if (requestScopedInitializer != null) {
            requestScopedInitializer.initialize(this.locator);
        }
        final UriRoutingContext uriRoutingCtx = this.uriRoutingCtxProvider.get();
        containerRequest.setUriRoutingContext(uriRoutingCtx);
        containerRequest.getRequestEventBuilder().setExtendedUriInfo(uriRoutingCtx);
        containerRequest.setReaderInterceptors(new Value<Iterable<ReaderInterceptor>>(){

            @Override
            public Iterable<ReaderInterceptor> get() {
                return uriRoutingCtx.getBoundReaderInterceptors();
            }
        });
        this.requestRef.get().set(containerRequest);
        this.uriInfoRef.get().set(uriRoutingCtx);
        this.httpHeadersRef.get().set(containerRequest);
        return containerRequest;
    }
}

