/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.jute.Record;
import org.apache.zookeeper.server.ObserverBean;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

public class Observer
extends Learner {
    Observer(QuorumPeer self, ObserverZooKeeperServer observerZooKeeperServer) {
        this.self = self;
        this.zk = observerZooKeeperServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Observer ").append(this.sock);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observeLeader() throws InterruptedException {
        this.zk.registerJMX(new ObserverBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            InetSocketAddress addr = this.findLeader();
            LOG.info("Observing " + addr);
            try {
                this.connectToLeader(addr);
                long newLeaderZxid = this.registerWithLeader(16);
                this.syncWithLeader(newLeaderZxid);
                QuorumPacket qp = new QuorumPacket();
                while (this.self.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (IOException e) {
                LOG.warn("Exception when observing the leader", e);
                try {
                    this.sock.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.pendingRevalidations.clear();
            }
            Object var6_6 = null;
            this.zk.unregisterJMX(this);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.zk.unregisterJMX(this);
            throw throwable;
        }
    }

    protected void processPacket(QuorumPacket qp) throws IOException {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                LOG.warn("Ignoring proposal");
                break;
            }
            case 4: {
                LOG.warn("Ignoring commit");
                break;
            }
            case 12: {
                LOG.error("Received an UPTODATE message after Observer started");
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                ((ObserverZooKeeperServer)this.zk).sync();
                break;
            }
            case 8: {
                TxnHeader hdr = new TxnHeader();
                Record txn = SerializeUtils.deserializeTxn(qp.getData(), hdr);
                Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
                request.txn = txn;
                request.hdr = hdr;
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                obs.commitRequest(request);
            }
        }
    }

    public void shutdown() {
        LOG.info("shutdown called", new Exception("shutdown Observer"));
        super.shutdown();
    }
}

