/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.SpringVersion;

public class SpringSecurityCoreVersion {
    private static final Log logger = LogFactory.getLog(SpringSecurityCoreVersion.class);
    public static final long SERIAL_VERSION_UID = 310L;
    static final String SPRING_MAJOR_VERSION = "3";
    static final String MIN_SPRING_VERSION = "3.0.7.RELEASE";

    public static String getVersion() {
        Package pkg = SpringSecurityCoreVersion.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    static {
        String springVersion = SpringVersion.getVersion();
        String version = SpringSecurityCoreVersion.getVersion();
        if (springVersion != null) {
            logger.info("You are running with Spring Security Core " + version);
            if (!springVersion.startsWith(SPRING_MAJOR_VERSION)) {
                logger.error("*** Spring Major version '3' expected, but you are running with version: " + springVersion + ". Please check your classpath for unwanted jar files.");
            }
            if (springVersion.compareTo(MIN_SPRING_VERSION) < 0) {
                logger.warn("**** You are advised to use Spring 3.0.7.RELEASE or later with this version. You are running: " + springVersion);
            }
        }
    }
}

