/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class CollectionMapping
extends ForeignReferenceMapping
implements ContainerMapping {
    protected transient ModifyQuery deleteAllQuery;
    protected transient boolean hasCustomDeleteAllQuery;
    protected ContainerPolicy containerPolicy;
    protected boolean hasOrderBy;
    protected DatabaseField listOrderField;
    protected boolean isListOrderFieldSupported;
    protected transient DataModifyQuery changeOrderTargetQuery;
    protected OrderCorrectionType orderCorrectionType;
    protected Boolean mustDeleteReferenceObjectsOneByOne = null;
    protected static boolean isSynchronizeOnMerge = Boolean.getBoolean("eclipselink.synchronizeCollectionOnMerge");

    public CollectionMapping() {
        this.selectionQuery = new ReadAllQuery();
        this.hasCustomDeleteAllQuery = false;
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
        this.hasOrderBy = false;
        this.isListOrderFieldSupported = false;
    }

    public void addAscendingOrdering(String queryKeyName) {
        this.hasOrderBy = true;
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addAscendingOrdering(queryKeyName);
    }

    public void addDescendingOrdering(String queryKeyName) {
        this.hasOrderBy = true;
        if (queryKeyName == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addDescendingOrdering(queryKeyName);
    }

    public void addOrderBy(String queryKeyName, boolean isDescending) {
        if (isDescending) {
            this.addDescendingOrdering(queryKeyName);
        } else {
            this.addAscendingOrdering(queryKeyName);
        }
    }

    public void addAggregateOrderBy(String aggregateName, String queryKeyName, boolean isDescending) {
        this.hasOrderBy = true;
        ReadAllQuery readAllQuery = (ReadAllQuery)this.getSelectionQuery();
        ExpressionBuilder builder = readAllQuery.getExpressionBuilder();
        Expression expression = null;
        if (aggregateName.contains(".")) {
            StringTokenizer st = new StringTokenizer(aggregateName, ".");
            while (st.hasMoreTokens()) {
                expression = expression == null ? builder.get(st.nextToken()) : expression.get(st.nextToken());
            }
            expression = expression.get(queryKeyName);
        } else {
            expression = aggregateName.equals("") ? builder.get(queryKeyName) : builder.get(aggregateName).get(queryKeyName);
        }
        if (isDescending) {
            readAllQuery.addOrdering(expression.descending());
        } else {
            readAllQuery.addOrdering(expression.ascending());
        }
    }

    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return this.containerPolicy.containerInstance(1);
        }
        return this.containerPolicy.cloneFor(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession, Integer refreshCascade, boolean isExisting, boolean isFromSharedCache) {
        ContainerPolicy containerPolicy = this.containerPolicy;
        if (attributeValue == null) {
            Object container = containerPolicy.containerInstance(1);
            if (cloningSession.isUnitOfWork() && this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && clone != null && ((ChangeTracker)clone)._persistence_getPropertyChangeListener() != null && container instanceof CollectionChangeTracker) {
                ((CollectionChangeTracker)container).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)container)._persistence_setPropertyChangeListener(((ChangeTracker)clone)._persistence_getPropertyChangeListener());
            }
            return container;
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        if (isSynchronizeOnMerge) {
            Object object = attributeValue;
            synchronized (object) {
                temporaryCollection = containerPolicy.cloneFor(attributeValue);
            }
        } else {
            temporaryCollection = attributeValue;
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            containerPolicy.addNextValueFromIteratorInto(valuesIterator, clone, cacheKey, clonedAttributeValue, this, refreshCascade, cloningSession, isExisting, isFromSharedCache);
        }
        if (cloningSession.isUnitOfWork() && this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && clone != null && ((ChangeTracker)clone)._persistence_getPropertyChangeListener() != null && clonedAttributeValue instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)clonedAttributeValue).setTrackedAttributeName(this.getAttributeName());
            ((CollectionChangeTracker)clonedAttributeValue)._persistence_setPropertyChangeListener(((ChangeTracker)clone)._persistence_getPropertyChangeListener());
        }
        if (temporaryCollection instanceof IndirectList) {
            ((IndirectList)clonedAttributeValue).setIsListOrderBrokenInDb(((IndirectList)temporaryCollection).isListOrderBrokenInDb());
        }
        return clonedAttributeValue;
    }

    @Override
    public Object buildContainerClone(Object attributeValue, AbstractSession cloningSession) {
        Object newContainer = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
        Object valuesIterator = this.containerPolicy.iteratorFor(attributeValue);
        while (this.containerPolicy.hasNext(valuesIterator)) {
            Object originalValue = this.containerPolicy.next(valuesIterator, cloningSession);
            this.containerPolicy.addInto(originalValue, newContainer, cloningSession);
        }
        return newContainer;
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, group.getSession());
        Object valuesIterator = this.containerPolicy.iteratorFor(attributeValue);
        attributeValue = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
        while (this.containerPolicy.hasNext(valuesIterator)) {
            Object originalValue;
            Object copyValue = originalValue = this.containerPolicy.next(valuesIterator, group.getSession());
            if (group.shouldCascadeAllParts() || group.shouldCascadePrivateParts() && this.isPrivateOwned() || group.shouldCascadeTree()) {
                copyValue = group.getSession().copyInternal(originalValue, group);
            } else {
                copyValue = group.getCopies().get(originalValue);
                if (copyValue == null) {
                    copyValue = originalValue;
                }
            }
            this.containerPolicy.addInto(copyValue, attributeValue, group.getSession());
        }
        this.getIndirectionPolicy().reset(copy);
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    public Object buildElementUnitOfWorkClone(Object element, Object parent, Integer refreshCascade, UnitOfWorkImpl unitOfWork, boolean isExisting, boolean isFromSharedCache) {
        if (refreshCascade != null) {
            switch (refreshCascade) {
                case 3: {
                    return unitOfWork.mergeClone(element, 3, true);
                }
                case 2: {
                    return unitOfWork.mergeClone(element, 2, true);
                }
                case 6: {
                    return unitOfWork.mergeClone(element, 4, true);
                }
            }
            return unitOfWork.mergeClone(element, 1, true);
        }
        if (isExisting) {
            return unitOfWork.registerExistingObject(element, isFromSharedCache);
        }
        return unitOfWork.registerObject(element);
    }

    public Object buildElementClone(Object element, Object parent, CacheKey parentCacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isFromSharedCache) {
        if (cloningSession.isUnitOfWork()) {
            return this.buildElementUnitOfWorkClone(element, parent, refreshCascade, (UnitOfWorkImpl)cloningSession, isExisting, isFromSharedCache);
        }
        if (this.referenceDescriptor.getCachePolicy().isProtectedIsolation()) {
            return cloningSession.createProtectedInstanceFromCachedData(element, refreshCascade, this.referenceDescriptor);
        }
        return element;
    }

    @Override
    public Object[] buildReferencesPKList(Object entity, Object attribute, AbstractSession session) {
        Object container = this.indirectionPolicy.getRealAttributeValueFromObject(entity, attribute);
        return this.containerPolicy.buildReferencesPKList(container, session);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (!this.cascadeRemove) {
            return;
        }
        Object cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        if (this.isPrivateOwned && this.usesIndirection() && !this.mustDeleteReferenceObjectsOneByOne() && !this.indirectionPolicy.objectIsEasilyInstantiated(cloneAttribute)) {
            return;
        }
        ContainerPolicy cp = this.containerPolicy;
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            if (this.isCascadeOnDeleteSetOnDatabase && this.isOneToManyMapping()) {
                uow.getCascadeDeleteObjects().add(nextObject);
            }
            uow.performRemove(nextObject, visitedObjects);
            cp.cascadePerformRemoveIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.indirectionPolicy.objectIsInstantiated(attributeValue)) {
            Object realObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
            ContainerPolicy cp = this.containerPolicy;
            Object cloneIter = cp.iteratorFor(realObjectCollection);
            while (cp.hasNext(cloneIter)) {
                Object nextObject = cp.next(cloneIter, uow);
                if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
                visitedObjects.put(nextObject, nextObject);
                uow.performRemovePrivateOwnedObjectFromChangeSet(nextObject, visitedObjects);
            }
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        Object cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            IndirectCollection collection;
            if (cloneAttribute instanceof IndirectCollection && (collection = (IndirectCollection)cloneAttribute).hasDeferredChanges()) {
                Iterator iterator = collection.getAddedElements().iterator();
                boolean cascade = this.isCascadePersist();
                while (iterator.hasNext()) {
                    Object nextObject = iterator.next();
                    if (this.isCandidateForPrivateOwnedRemoval()) {
                        uow.removePrivateOwnedObject(this, nextObject);
                    }
                    uow.discoverAndPersistUnregisteredNewObjects(nextObject, cascade, newObjects, unregisteredExistingObjects, visitedObjects, cascadeErrors);
                }
            }
            return;
        }
        ContainerPolicy containerPolicy = this.containerPolicy;
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object iterator = containerPolicy.iteratorFor(cloneObjectCollection);
        boolean cascade = this.isCascadePersist();
        while (containerPolicy.hasNext(iterator)) {
            Object wrappedObject = containerPolicy.nextEntry(iterator, uow);
            Object nextObject = containerPolicy.unwrapIteratorResult(wrappedObject);
            if (this.isCandidateForPrivateOwnedRemoval()) {
                uow.removePrivateOwnedObject(this, nextObject);
            }
            uow.discoverAndPersistUnregisteredNewObjects(nextObject, cascade, newObjects, unregisteredExistingObjects, visitedObjects, cascadeErrors);
            containerPolicy.cascadeDiscoverAndPersistUnregisteredNewObjects(wrappedObject, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        if (!this.cascadePersist) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null || !this.indirectionPolicy.objectIsInstantiated(attributeValue) && !uow.isCloneNewObject(object)) {
            return;
        }
        ContainerPolicy cp = this.containerPolicy;
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        boolean shouldAddPrivateOwnedObject = this.isCandidateForPrivateOwnedRemoval() && uow.shouldDiscoverNewObjects() && uow.isCloneNewObject(object);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (shouldAddPrivateOwnedObject && nextObject != null) {
                uow.addPrivateOwnedObject(this, nextObject);
            }
            uow.registerNewObjectForPersist(nextObject, visitedObjects);
            cp.cascadeRegisterNewIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> record) {
    }

    @Override
    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        CollectionChangeRecord collectionRecord = (CollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
        if (this.isPrivateOwned()) {
            this.postCalculateChanges(collectionRecord, (UnitOfWorkImpl)session);
        }
    }

    @Override
    public Object clone() {
        CollectionMapping clone = (CollectionMapping)super.clone();
        clone.setDeleteAllQuery((ModifyQuery)this.getDeleteAllQuery().clone());
        if (this.listOrderField != null) {
            clone.listOrderField = this.listOrderField.clone();
        }
        if (this.changeOrderTargetQuery != null) {
            clone.changeOrderTargetQuery = (DataModifyQuery)this.changeOrderTargetQuery.clone();
        }
        clone.containerPolicy = (ContainerPolicy)this.containerPolicy.clone();
        return clone;
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        this.containerPolicy.compareCollectionsForChange(oldCollection, newCollection, (CollectionChangeRecord)changeRecord, session, this.getReferenceDescriptor());
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        Object backUpObjectCollection = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (cloneAttribute == null && backUpAttribute == null) {
                return null;
            }
            backUpObjectCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : this.containerPolicy.containerInstance(1);
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpObjectCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            changeRecord.setOriginalCollection(backUpObjectCollection);
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        return super.compareObjects(firstObjectCollection, secondObjectCollection, session);
    }

    public void writeChanges(ObjectChangeSet changeSet, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        CollectionChangeRecord record = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (record != null) {
            for (ObjectChangeSet removedChangeSet : record.getRemoveObjectList().values()) {
                this.objectRemovedDuringUpdate(query, this.containerPolicy.getCloneDataFromChangeSet(removedChangeSet), null);
                if (removedChangeSet.getOldKey() == null) continue;
                this.containerPolicy.propogatePostUpdate(query, removedChangeSet.getOldKey());
            }
            HashMap<DatabaseField, Integer> extraData = null;
            Object currentObjects = null;
            for (ObjectChangeSet addedChangeSet : record.getAddObjectList().values()) {
                if (this.listOrderField != null) {
                    extraData = new HashMap<DatabaseField, Integer>(1);
                    Integer addedIndexInList = record.getOrderedAddObjectIndices().get(addedChangeSet);
                    if (addedIndexInList == null) {
                        if (currentObjects == null) {
                            currentObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
                        }
                        addedIndexInList = ((List)currentObjects).indexOf(addedChangeSet.getUnitOfWorkClone());
                    }
                    extraData.put(this.listOrderField, addedIndexInList);
                }
                this.objectAddedDuringUpdate(query, this.containerPolicy.getCloneDataFromChangeSet(addedChangeSet), addedChangeSet, extraData);
                if (addedChangeSet.getNewKey() == null) continue;
                this.containerPolicy.propogatePostUpdate(query, addedChangeSet.getNewKey());
            }
            if (this.listOrderField != null) {
                List previousList = (List)this.getRealCollectionAttributeValueFromObject(query.getBackupClone(), query.getSession());
                int previousSize = previousList.size();
                if (currentObjects == null) {
                    currentObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
                }
                List currentList = (List)currentObjects;
                int currentSize = currentList.size();
                boolean shouldRepairOrder = false;
                if (currentList instanceof IndirectList) {
                    shouldRepairOrder = ((IndirectList)currentList).isListOrderBrokenInDb();
                }
                if (previousList == currentList) {
                    List<Integer> currentIndexes = record.getCurrentIndexesOfOriginalObjects(currentList);
                    int i = 0;
                    while (i < currentIndexes.size()) {
                        int currentIndex = currentIndexes.get(i);
                        if (currentIndex >= 0 && (currentIndex != i || shouldRepairOrder)) {
                            this.objectOrderChangedDuringUpdate(query, currentList.get(currentIndex), currentIndex);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < previousSize) {
                        int newIndex;
                        Object prevObject = previousList.get(i);
                        Object currentObject = null;
                        if (i < currentSize) {
                            currentObject = currentList.get(i);
                        }
                        if ((prevObject != currentObject || shouldRepairOrder) && (newIndex = currentList.indexOf(prevObject)) >= 0) {
                            this.objectOrderChangedDuringUpdate(query, prevObject, newIndex);
                        }
                        ++i;
                    }
                }
                if (shouldRepairOrder) {
                    ((IndirectList)currentList).setIsListOrderBrokenInDb(false);
                    record.setOrderHasBeenRepaired(true);
                }
            }
        }
    }

    protected void compareObjectsAndWrite(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object primaryKey;
        Object wrappedObject;
        Object currentObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        Object previousObjects = this.readPrivateOwnedForObject(query);
        if (previousObjects == null) {
            previousObjects = this.getContainerPolicy().containerInstance(1);
        }
        if (this.listOrderField != null && this.isAggregateCollectionMapping()) {
            this.compareListsAndWrite((List)previousObjects, (List)currentObjects, query);
            return;
        }
        ContainerPolicy cp = this.containerPolicy;
        HashMap<Object, Object> previousObjectsByKey = new HashMap<Object, Object>(cp.sizeFor(previousObjects));
        HashMap<Object, Object> currentObjectsByKey = new HashMap<Object, Object>(cp.sizeFor(currentObjects));
        IdentityHashMap<Object, Object> keysOfCurrentObjects = new IdentityHashMap<Object, Object>(cp.sizeFor(currentObjects) + 1);
        Object currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            Object currentObject = cp.next(currentObjectsIter, query.getSession());
            try {
                Object primaryKey2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(currentObject, query.getSession());
                currentObjectsByKey.put(primaryKey2, currentObject);
                keysOfCurrentObjects.put(currentObject, primaryKey2);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
        Object previousObjectsIter = cp.iteratorFor(previousObjects);
        while (cp.hasNext(previousObjectsIter)) {
            wrappedObject = cp.nextEntry(previousObjectsIter, query.getSession());
            Map mapKeyFields = this.containerPolicy.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession());
            Object previousObject = this.containerPolicy.unwrapIteratorResult(wrappedObject);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(previousObject, query.getSession());
            previousObjectsByKey.put(primaryKey, previousObject);
            if (currentObjectsByKey.containsKey(primaryKey)) continue;
            this.objectRemovedDuringUpdate(query, wrappedObject, mapKeyFields);
            cp.propogatePostUpdate(query, wrappedObject);
        }
        currentObjectsIter = cp.iteratorFor(currentObjects);
        while (cp.hasNext(currentObjectsIter)) {
            wrappedObject = cp.nextEntry(currentObjectsIter, query.getSession());
            Object currentObject = this.containerPolicy.unwrapIteratorResult(wrappedObject);
            try {
                Map mapKeyFields = this.containerPolicy.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession());
                primaryKey = keysOfCurrentObjects.get(currentObject);
                if (!previousObjectsByKey.containsKey(primaryKey)) {
                    this.objectAddedDuringUpdate(query, currentObject, null, mapKeyFields);
                    cp.propogatePostUpdate(query, wrappedObject);
                    continue;
                }
                this.objectUnchangedDuringUpdate(query, currentObject, previousObjectsByKey, primaryKey);
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
    }

    protected void compareListsAndWrite(List previousList, List currentList, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean compareObjectsWithoutPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        block6: {
            if (this.listOrderField != null) {
                return this.compareLists((List)firstCollection, (List)secondCollection, session, false);
            }
            cp = this.containerPolicy;
            if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
                return false;
            }
            firstIter = cp.iteratorFor(firstCollection);
            secondIter = cp.iteratorFor(secondCollection);
            keyValues = new HashMap<Object, Object>();
            if (!this.isMapKeyMapping()) ** GOTO lbl27
            while (cp.hasNext(secondIter)) {
                secondObject = (Map.Entry)cp.nextEntry(secondIter, session);
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject.getValue(), session);
                key = secondObject.getKey();
                keyValues.put(key, primaryKey);
            }
            while (cp.hasNext(firstIter)) {
                firstObject = (Map.Entry)cp.nextEntry(firstIter, session);
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject.getValue(), session);
                if (primaryKey.equals(keyValues.get(key = firstObject.getKey()))) continue;
                return false;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                secondObject = cp.next(secondIter, session);
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
                keyValues.put(primaryKey, primaryKey);
lbl27:
                // 2 sources

                ** while (cp.hasNext((Object)secondIter))
            }
lbl28:
            // 2 sources

            while (cp.hasNext(firstIter)) {
                firstObject = cp.next(firstIter, session);
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
                if (keyValues.containsKey(primaryKey)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean compareObjectsWithPrivateOwned(Object firstCollection, Object secondCollection, AbstractSession session) {
        Object primaryKey;
        if (this.listOrderField != null) {
            return this.compareLists((List)firstCollection, (List)secondCollection, session, true);
        }
        ContainerPolicy cp = this.containerPolicy;
        if (cp.sizeFor(firstCollection) != cp.sizeFor(secondCollection)) {
            return false;
        }
        Object firstIter = cp.iteratorFor(firstCollection);
        Object secondIter = cp.iteratorFor(secondCollection);
        HashMap<Object, Object> keyValueToObject = new HashMap<Object, Object>(cp.sizeFor(firstCollection));
        while (cp.hasNext(secondIter)) {
            Object secondObject = cp.next(secondIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
            keyValueToObject.put(primaryKey, secondObject);
        }
        while (cp.hasNext(firstIter)) {
            Object firstObject = cp.next(firstIter, session);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            if (keyValueToObject.containsKey(primaryKey)) {
                Object object = keyValueToObject.get(primaryKey);
                if (session.compareObjects(firstObject, object)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected boolean compareLists(List firstList, List secondList, AbstractSession session, boolean withPrivateOwned) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        int size = firstList.size();
        int i = 0;
        while (i < size) {
            Object secondKey;
            Object firstKey;
            Object firstObject = firstList.get(i);
            Object secondObject = secondList.get(i);
            if (withPrivateOwned ? !session.compareObjects(firstObject, secondObject) : !(firstKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session)).equals(secondKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    @Override
    public Object extractResultFromBatchQuery(ReadQuery batchQuery, CacheKey parentCacheKey, AbstractRecord sourceRow, AbstractSession session, ObjectLevelReadQuery originalQuery) throws QueryException {
        Object result = super.extractResultFromBatchQuery(batchQuery, parentCacheKey, sourceRow, session, originalQuery);
        if (result == null) {
            return this.containerPolicy.containerInstance();
        }
        return result;
    }

    @Override
    protected void executeBatchQuery(DatabaseQuery query, CacheKey parentCacheKey, Map referenceObjectsByKey, AbstractSession session, AbstractRecord translationRow) {
        ReadAllQuery batchQuery = (ReadAllQuery)query;
        ComplexQueryResult complexResult = (ComplexQueryResult)session.executeQuery((DatabaseQuery)batchQuery, translationRow);
        Object results = complexResult.getResult();
        Iterator rowsIterator = ((List)complexResult.getData()).iterator();
        ContainerPolicy queryContainerPolicy = batchQuery.getContainerPolicy();
        if (this.containerPolicy.shouldAddAll()) {
            HashMap<Object, List[]> referenceObjectsAndRowsByKey = new HashMap<Object, List[]>();
            Object objectsIterator = queryContainerPolicy.iteratorFor(results);
            while (queryContainerPolicy.hasNext(objectsIterator)) {
                Object eachReferenceObject = queryContainerPolicy.next(objectsIterator, session);
                AbstractRecord row = (AbstractRecord)rowsIterator.next();
                Object eachReferenceKey = this.extractKeyFromTargetRow(row, session);
                List[] objectsAndRows = (List[])referenceObjectsAndRowsByKey.get(eachReferenceKey);
                if (objectsAndRows == null) {
                    objectsAndRows = new List[]{new ArrayList(), new ArrayList()};
                    referenceObjectsAndRowsByKey.put(eachReferenceKey, objectsAndRows);
                }
                objectsAndRows[0].add(eachReferenceObject);
                objectsAndRows[1].add(row);
            }
            for (Map.Entry entry : referenceObjectsAndRowsByKey.entrySet()) {
                Object eachReferenceKey = entry.getKey();
                List objects = ((List[])entry.getValue())[0];
                List rows = ((List[])entry.getValue())[1];
                Object container = this.containerPolicy.containerInstance(objects.size());
                this.containerPolicy.addAll(objects, container, query.getSession(), (List<AbstractRecord>)rows, batchQuery, parentCacheKey, true);
                referenceObjectsByKey.put(eachReferenceKey, container);
            }
        } else {
            Object objectsIterator = queryContainerPolicy.iteratorFor(results);
            while (queryContainerPolicy.hasNext(objectsIterator)) {
                Object eachReferenceObject = queryContainerPolicy.next(objectsIterator, session);
                AbstractRecord row = (AbstractRecord)rowsIterator.next();
                while (row == null && rowsIterator.hasNext()) {
                    row = (AbstractRecord)rowsIterator.next();
                }
                Object eachReferenceKey = this.extractKeyFromTargetRow(row, session);
                Object container = referenceObjectsByKey.get(eachReferenceKey);
                if (container == null || container == Helper.NULL_VALUE) {
                    container = this.containerPolicy.containerInstance();
                    referenceObjectsByKey.put(eachReferenceKey, container);
                }
                this.containerPolicy.addInto(eachReferenceObject, container, session, row, batchQuery, parentCacheKey, true);
            }
        }
    }

    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        throw QueryException.batchReadingNotSupported(this, null);
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        Object attributeValue = this.getRealAttributeValueFromObject(object, session);
        if (attributeValue == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        ObjectLevelReadQuery tempQuery = query;
        if (!tempQuery.shouldMaintainCache() && (!tempQuery.shouldCascadeParts() || tempQuery.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            tempQuery = null;
        }
        Object remoteAttributeValue = session.getObjectsCorrespondingToAll(attributeValue, objectDescriptors, processedObjects, tempQuery, this.containerPolicy);
        this.setRealAttributeValueInObject(object, remoteAttributeValue);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    @Override
    public Expression getJoinCriteria(ObjectExpression context, Expression base) {
        Expression selectionCriteria = this.getSelectionCriteria();
        Expression keySelectionCriteria = this.containerPolicy.getKeySelectionCriteria();
        if (keySelectionCriteria != null) {
            selectionCriteria = selectionCriteria.and(keySelectionCriteria);
        }
        return context.getBaseExpression().twist(selectionCriteria, base);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, DistributedSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return session.getObjectsCorrespondingToAll(object, objectDescriptors, processedObjects, query, this.containerPolicy);
    }

    public List<Expression> getOrderByQueryKeyExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (this.getSelectionQuery() != null && this.getSelectionQuery().isReadAllQuery()) {
            for (Expression orderExpression : ((ReadAllQuery)this.getSelectionQuery()).getOrderByExpressions()) {
                if (!orderExpression.isFunctionExpression() || !((FunctionExpression)orderExpression).getBaseExpression().isQueryKeyExpression()) continue;
                expressions.add(orderExpression);
            }
        }
        return expressions;
    }

    protected ContainerPolicy getSelectionQueryContainerPolicy() {
        return ((ReadAllQuery)this.getSelectionQuery()).getContainerPolicy();
    }

    @Override
    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.containerPolicy.containerInstance(1);
        }
        return value;
    }

    public DatabaseField getListOrderField() {
        return this.listOrderField;
    }

    public List<DatabaseField> getTargetPrimaryKeyFields() {
        return this.getReferenceDescriptor().getPrimaryKeyFields();
    }

    public OrderCorrectionType getOrderCorrectionType() {
        return this.orderCorrectionType;
    }

    protected boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public boolean hasOrderBy() {
        return this.hasOrderBy;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.setFields(this.collectFields());
        this.containerPolicy.prepare(this.getSelectionQuery(), session);
        if (!this.usesIndirection() && !this.getAttributeAccessor().getAttributeClass().isAssignableFrom(this.containerPolicy.getContainerClass())) {
            throw DescriptorException.incorrectCollectionPolicy(this, this.getAttributeAccessor().getAttributeClass(), this.containerPolicy.getContainerClass());
        }
        if (this.listOrderField != null) {
            this.initializeListOrderField(session);
        }
    }

    protected void initializeListOrderField(AbstractSession session) {
        if (!List.class.isAssignableFrom(this.getAttributeAccessor().getAttributeClass())) {
            throw DescriptorException.listOrderFieldRequiersList(this.getDescriptor(), this);
        }
        boolean isAttributeAssignableFromIndirectList = this.getAttributeAccessor().getAttributeClass().isAssignableFrom(IndirectList.class);
        if (this.orderCorrectionType == null) {
            this.orderCorrectionType = isAttributeAssignableFromIndirectList ? OrderCorrectionType.READ_WRITE : OrderCorrectionType.READ;
        } else if (this.orderCorrectionType == OrderCorrectionType.READ_WRITE && !isAttributeAssignableFromIndirectList) {
            throw DescriptorException.listOrderFieldRequiersIndirectList(this.getDescriptor(), this);
        }
        ContainerPolicy originalQueryContainerPolicy = this.getSelectionQueryContainerPolicy();
        if (!this.containerPolicy.isOrderedListPolicy()) {
            this.setContainerPolicy(new OrderedListContainerPolicy(this.containerPolicy.getContainerClass()));
            this.getContainerPolicy().prepare(this.getSelectionQuery(), session);
        }
        OrderedListContainerPolicy orderedListContainerPolicy = (OrderedListContainerPolicy)this.containerPolicy;
        orderedListContainerPolicy.setListOrderField(this.listOrderField);
        orderedListContainerPolicy.setOrderCorrectionType(this.orderCorrectionType);
        if (this.containerPolicy.getContainerClass().isAssignableFrom(IndirectList.class) && !IndirectList.class.isAssignableFrom(originalQueryContainerPolicy.getContainerClass()) && this.orderCorrectionType != OrderCorrectionType.READ_WRITE || originalQueryContainerPolicy == this.getSelectionQueryContainerPolicy()) {
            if (originalQueryContainerPolicy.getClass().equals(orderedListContainerPolicy.getClass())) {
                OrderedListContainerPolicy queryOrderedListContainerPolicy = (OrderedListContainerPolicy)originalQueryContainerPolicy;
                queryOrderedListContainerPolicy.setListOrderField(this.listOrderField);
                queryOrderedListContainerPolicy.setOrderCorrectionType(this.orderCorrectionType);
            } else {
                OrderedListContainerPolicy queryOrderedListContainerPolicy = (OrderedListContainerPolicy)orderedListContainerPolicy.clone();
                queryOrderedListContainerPolicy.setContainerClass(originalQueryContainerPolicy.getContainerClass());
                this.setSelectionQueryContainerPolicy(queryOrderedListContainerPolicy);
            }
        }
        if (this.listOrderField.getType() == null) {
            this.listOrderField.setType(Integer.class);
        }
        this.buildListOrderField();
        if (this.getSelectionQuery().isReadAllQuery() && this.shouldUseListOrderFieldTableExpression()) {
            this.initializeListOrderFieldTable(session);
        }
        this.initializeChangeOrderTargetQuery(session);
    }

    protected void initializeListOrderFieldTable(AbstractSession session) {
    }

    protected void buildListOrderField() {
        if (this.listOrderField.hasTableName()) {
            if (!this.getReferenceDescriptor().getDefaultTable().equals(this.listOrderField.getTable())) {
                throw DescriptorException.listOrderFieldTableIsWrong(this.getDescriptor(), this, this.listOrderField.getTable(), this.getReferenceDescriptor().getDefaultTable());
            }
        } else {
            this.listOrderField.setTable(this.getReferenceDescriptor().getDefaultTable());
        }
        this.listOrderField = this.getReferenceDescriptor().buildField(this.listOrderField);
    }

    public Boolean shouldUseLazyInstantiationForIndirectCollection() {
        if (this.getIndirectionPolicy() == null) {
            return null;
        }
        return this.getIndirectionPolicy().shouldUseLazyInstantiation();
    }

    public boolean shouldUseListOrderFieldTableExpression() {
        return false;
    }

    protected void initializeChangeOrderTargetQuery(AbstractSession session) {
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    public boolean isMapKeyObjectRelationship() {
        return this.containerPolicy.isMapKeyObject();
    }

    public boolean isAttributeValueInstantiatedOrChanged(Object object) {
        return this.indirectionPolicy.objectIsInstantiatedOrChanged(this.getAttributeValueFromObject(object));
    }

    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iterateReferenceObjectForMapping(element, this);
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (realAttributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.containerPolicy;
        Object iter = cp.iteratorFor(realAttributeValue);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            this.iterateOnElement(iterator, object);
            cp.iterateOnMapKey(iterator, wrappedObject);
        }
    }

    @Override
    public void load(Object object, AttributeItem item, AbstractSession session) {
        this.instantiateAttribute(object, session);
        if (item.getGroup() != null) {
            Object value = this.getRealAttributeValueFromObject(object, session);
            ContainerPolicy cp = this.containerPolicy;
            Object iterator = cp.iteratorFor(value);
            while (cp.hasNext(iterator)) {
                Object wrappedObject = cp.nextEntry(iterator, session);
                Object nestedObject = cp.unwrapIteratorResult(wrappedObject);
                session.load(nestedObject, (AttributeGroup)item.getGroup(nestedObject.getClass()));
            }
        }
    }

    public boolean mustDeleteReferenceObjectsOneByOne() {
        return this.mustDeleteReferenceObjectsOneByOne == null || this.mustDeleteReferenceObjectsOneByOne != false;
    }

    @Override
    public void mergeChangesIntoObject(Object target, org.eclipse.persistence.internal.sessions.ChangeRecord chgRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        Object valueOfTarget = null;
        Object valueOfSource = null;
        ContainerPolicy containerPolicy = this.containerPolicy;
        CollectionChangeRecord changeRecord = (CollectionChangeRecord)chgRecord;
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet();
        if (this.isAttributeValueInstantiated(target)) {
            valueOfTarget = changeRecord.getOwner().isNew() ? containerPolicy.containerInstance(changeRecord.getAddObjectList().size()) : (isSynchronizeOnMerge ? this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession()) : containerPolicy.cloneFor(this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession())));
            containerPolicy.mergeChanges(changeRecord, valueOfTarget, this.shouldMergeCascadeParts(mergeManager), mergeManager, targetSession, isSynchronizeOnMerge);
        } else {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            if (!this.isAttributeValueInstantiated(source)) {
                return;
            }
            valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
            Object iterator = containerPolicy.iteratorFor(valueOfSource);
            valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
            while (containerPolicy.hasNext(iterator)) {
                Object objectToMerge = containerPolicy.next(iterator, mergeManager.getSession());
                if (this.shouldMergeCascadeParts(mergeManager) && valueOfSource != null) {
                    ObjectChangeSet changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(objectToMerge);
                    mergeManager.mergeChanges(objectToMerge, changeSet, targetSession);
                }
                containerPolicy.addInto(mergeManager.getTargetVersionOfSourceObject(objectToMerge, this.referenceDescriptor, targetSession), valueOfTarget, mergeManager.getSession());
            }
        }
        if (valueOfTarget == null) {
            valueOfTarget = containerPolicy.containerInstance();
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        CollectionChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        Object newContainer;
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.isForRefresh()) {
            if (!this.isAttributeValueInstantiated(target)) {
                if (this.shouldRefreshCascadeParts(mergeManager)) {
                    Object attributeValue = this.getAttributeValueFromObject(source);
                    Object clonedAttributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, source, null, target, null, mergeManager.getSession(), false);
                    this.setAttributeValueInObject(target, clonedAttributeValue);
                }
                return;
            }
        } else if (!this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        AbstractSession mergeSession = mergeManager.getSession();
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeSession);
        ContainerPolicy containerPolicy = this.containerPolicy;
        containerPolicy.sizeFor(valueOfTarget);
        boolean fireChangeEvents = false;
        ObjectChangeListener listener = null;
        Object valueOfSourceCloned = null;
        if (!mergeManager.isForRefresh()) {
            valueOfSourceCloned = valueOfSource;
            newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSourceCloned));
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
                fireChangeEvents = valueOfSourceCloned != valueOfTarget;
                Object iterator = containerPolicy.iteratorFor(valueOfTarget);
                listener = (ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener();
                if (fireChangeEvents) {
                    Integer zero = 0;
                    while (containerPolicy.hasNext(iterator)) {
                        CollectionChangeEvent event = containerPolicy.createChangeEvent(target, this.getAttributeName(), valueOfTarget, containerPolicy.next(iterator, mergeSession), CollectionChangeEvent.REMOVE, zero, false);
                        listener.internalPropertyChange(event);
                    }
                }
                if (newContainer instanceof ChangeTracker) {
                    ((CollectionChangeTracker)newContainer).setTrackedAttributeName(this.getAttributeName());
                    ((CollectionChangeTracker)newContainer)._persistence_setPropertyChangeListener(listener);
                }
                if (valueOfTarget instanceof ChangeTracker) {
                    ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
                }
            }
            valueOfTarget = newContainer;
        } else {
            if (isSynchronizeOnMerge) {
                newContainer = valueOfSource;
                synchronized (newContainer) {
                    valueOfSourceCloned = containerPolicy.cloneFor(valueOfSource);
                }
            } else {
                valueOfSourceCloned = valueOfSource;
            }
            this.setRealAttributeValueInObject(target, containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSourceCloned)));
            containerPolicy.clear(valueOfTarget);
        }
        Object sourceIterator = containerPolicy.iteratorFor(valueOfSourceCloned);
        int i = 0;
        while (containerPolicy.hasNext(sourceIterator)) {
            Object mergedObject;
            Object wrappedObject = containerPolicy.nextEntry(sourceIterator, mergeManager.getSession());
            Object object = containerPolicy.unwrapIteratorResult(wrappedObject);
            if (object == null) continue;
            if (this.shouldMergeCascadeParts(mergeManager)) {
                mergedObject = null;
                if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                    mergedObject = mergeManager.mergeChanges(mergeManager.getObjectToMerge(object, this.referenceDescriptor, targetSession), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object), targetSession);
                    if (listener != null && !fireChangeEvents && mergedObject != object) {
                        this.descriptor.getObjectChangePolicy().updateListenerForSelfMerge(listener, this, object, mergedObject, (UnitOfWorkImpl)mergeManager.getSession());
                    }
                } else {
                    mergedObject = mergeManager.mergeChanges(mergeManager.getObjectToMerge(object, this.referenceDescriptor, targetSession), null, targetSession);
                }
            }
            wrappedObject = containerPolicy.createWrappedObjectFromExistingWrappedObject(wrappedObject, source, this.referenceDescriptor, mergeManager, targetSession);
            if (isSynchronizeOnMerge) {
                mergedObject = valueOfTarget;
                synchronized (mergedObject) {
                    if (fireChangeEvents) {
                        CollectionChangeEvent event = containerPolicy.createChangeEvent(target, this.getAttributeName(), valueOfTarget, wrappedObject, CollectionChangeEvent.ADD, i++, false);
                        listener.internalPropertyChange(event);
                    }
                    containerPolicy.addInto(wrappedObject, valueOfTarget, mergeManager.getSession());
                    continue;
                }
            }
            if (fireChangeEvents) {
                CollectionChangeEvent event = containerPolicy.createChangeEvent(target, this.getAttributeName(), valueOfTarget, wrappedObject, CollectionChangeEvent.ADD, i++, false);
                listener.internalPropertyChange(event);
            }
            containerPolicy.addInto(wrappedObject, valueOfTarget, mergeManager.getSession());
        }
        if (fireChangeEvents && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet, Map extraData) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.setIsExecutionClone(true);
            insertQuery.setObject(this.containerPolicy.unwrapIteratorResult(objectAdded));
            insertQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(insertQuery);
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (changeSet == null && query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(query.getObject());
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(this.containerPolicy.unwrapIteratorResult(objectAdded));
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    protected void objectOrderChangedDuringUpdate(WriteObjectQuery query, Object orderChangedObject, int orderIndex) {
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        List<DatabaseField> targetPrimaryKeyFields = this.getTargetPrimaryKeyFields();
        int size = targetPrimaryKeyFields.size();
        int index = 0;
        while (index < size) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(orderChangedObject, targetPrimaryKey, query.getSession());
            databaseRow.put(targetPrimaryKey, targetKeyValue);
            ++index;
        }
        databaseRow.put(this.listOrderField, (Object)orderIndex);
        query.getSession().executeQuery((DatabaseQuery)this.changeOrderTargetQuery, databaseRow);
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted, Map extraData) throws DatabaseException, OptimisticLockException {
        if (this.isPrivateOwned() && !query.shouldCascadeOnlyDependentParts()) {
            this.containerPolicy.deleteWrappedObject(objectDeleted, query.getSession());
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        WriteObjectQuery writeQuery = new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        query.getSession().executeQuery(writeQuery);
    }

    @Override
    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet ocs : collectionChangeRecord.getRemoveObjectList().values()) {
            this.containerPolicy.postCalculateChanges(ocs, this.referenceDescriptor, this, uow);
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Iterator it = (Iterator)this.containerPolicy.iteratorFor(this.getRealAttributeValueFromObject(object, uow));
            while (it.hasNext()) {
                Object clone = it.next();
                this.containerPolicy.recordPrivateOwnedRemovals(clone, this.referenceDescriptor, uow);
            }
        }
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        super.postPrepareNestedBatchQuery(batchQuery, query);
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        mappingBatchQuery.setShouldIncludeData(true);
        this.containerPolicy.addAdditionalFieldsToQuery(mappingBatchQuery, this.getAdditionalFieldsBaseExpression(mappingBatchQuery));
    }

    protected Expression getAdditionalFieldsBaseExpression(ReadQuery query) {
        return ((ReadAllQuery)query).getExpressionBuilder();
    }

    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, ClassDescriptor descriptor, AbstractSession session) {
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.containerPolicy.propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePostDelete(query, wrappedObject);
            }
        }
    }

    @Override
    public void postInitialize(AbstractSession session) {
        super.postInitialize(session);
        this.containerPolicy.postInitialize(session);
        if (this.referenceDescriptor != null && this.mustDeleteReferenceObjectsOneByOne == null) {
            this.mustDeleteReferenceObjectsOneByOne = this.referenceDescriptor.hasDependencyOnParts() || this.referenceDescriptor.usesOptimisticLocking() || this.referenceDescriptor.hasInheritance() && this.referenceDescriptor.getInheritancePolicy().shouldReadSubclasses() || this.referenceDescriptor.hasMultipleTables() || this.containerPolicy.propagatesEventsToCollection() || this.referenceDescriptor.hasRelationshipsExceptBackpointer(this.descriptor);
        } else if (this.mustDeleteReferenceObjectsOneByOne == null) {
            this.mustDeleteReferenceObjectsOneByOne = false;
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        if (this.containerPolicy.propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePostInsert(query, wrappedObject);
            }
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.containerPolicy.propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreInsert(query, wrappedObject);
            }
        }
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.containerPolicy.propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreUpdate(query, wrappedObject);
            }
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Map backupclones, Object key) throws DatabaseException, OptimisticLockException {
        this.objectUnchangedDuringUpdate(query, object);
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return this.getRealCollectionAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
        }
        this.prepareTranslationRow(modifyQuery.getTranslationRow(), modifyQuery.getObject(), modifyQuery.getDescriptor(), modifyQuery.getSession());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)this.getSelectionQuery(), modifyQuery.getTranslationRow());
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersInAll(object, this.containerPolicy);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteAllQuery(ModifyQuery query) {
        this.setDeleteAllQuery(query);
        this.setHasCustomDeleteAllQuery(true);
    }

    protected void setDeleteAllQuery(ModifyQuery query) {
        this.deleteAllQuery = query;
    }

    public void setDeleteAllSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    public void setDeleteAllCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteAllQuery(query);
    }

    protected void setHasCustomDeleteAllQuery(boolean bool) {
        this.hasCustomDeleteAllQuery = bool;
    }

    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setSessionName(String name) {
        this.getDeleteAllQuery().setSessionName(name);
        this.getSelectionQuery().setSessionName(name);
    }

    public void setUseLazyInstantiationForIndirectCollection(Boolean useLazyInstantiation) {
        if (this.getIndirectionPolicy() != null) {
            this.getIndirectionPolicy().setUseLazyInstantiation(useLazyInstantiation);
        }
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
        }
        this.containerPolicy.recordAddToCollectionInChangeRecord((ObjectChangeSet)changeSetToAdd, collectionChangeRecord);
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToAdd).setNewKey(referenceKey);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
        }
        this.containerPolicy.recordRemoveFromCollectionInChangeRecord((ObjectChangeSet)changeSetToRemove, collectionChangeRecord);
        if (referenceKey != null) {
            ((ObjectChangeSet)changeSetToRemove).setOldKey(referenceKey);
        }
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.recreateOriginalCollection(oldValue, uow);
        }
        collectionChangeRecord.setLatestCollection(newValue);
    }

    @Override
    public void updateChangeRecordForSelfMerge(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object source, Object target, UnitOfWorkChangeSet parentUOWChangeSet, UnitOfWorkImpl unitOfWork) {
        this.getContainerPolicy().updateChangeRecordForSelfMerge(changeRecord, source, target, this, parentUOWChangeSet, unitOfWork);
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null && event.getNewValue() != null) {
            Object newValue = event.getNewValue();
            ClassDescriptor descriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : uow.getDescriptor(newValue);
            newValue = descriptor.getObjectBuilder().unwrapObject(newValue, uow);
            ObjectChangeSet changeSetToAdd = descriptor.getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)changeSet.getUOWChangeSet(), uow);
            CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (collectionChangeRecord == null) {
                collectionChangeRecord = new CollectionChangeRecord(changeSet);
                collectionChangeRecord.setAttribute(this.getAttributeName());
                collectionChangeRecord.setMapping(this);
                changeSet.addChange(collectionChangeRecord);
            }
            if (!collectionChangeRecord.isDeferred()) {
                this.containerPolicy.recordUpdateToCollectionInChangeRecord(event, changeSetToAdd, collectionChangeRecord);
            }
        }
    }

    @Override
    public void setChangeListener(Object clone, PropertyChangeListener listener, UnitOfWorkImpl uow) {
        if (this.indirectionPolicy.usesTransparentIndirection() && this.isAttributeValueInstantiated(clone)) {
            Object attributeValue = this.getRealAttributeValueFromObject(clone, uow);
            if (!(attributeValue instanceof CollectionChangeTracker)) {
                Object container = attributeValue;
                ContainerPolicy containerPolicy = this.containerPolicy;
                if (attributeValue == null) {
                    container = containerPolicy.containerInstance(1);
                } else {
                    container = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
                    Object iterator = containerPolicy.iteratorFor(attributeValue);
                    while (containerPolicy.hasNext(iterator)) {
                        containerPolicy.addInto(containerPolicy.nextEntry(iterator, uow), container, uow);
                    }
                }
                this.setRealAttributeValueInObject(clone, container);
                ((CollectionChangeTracker)container).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)container)._persistence_setPropertyChangeListener(listener);
            } else {
                ((CollectionChangeTracker)attributeValue).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)attributeValue)._persistence_setPropertyChangeListener(listener);
            }
        }
        if (this.indirectionPolicy.usesTransparentIndirection()) {
            ((IndirectCollection)this.getRealAttributeValueFromObject(clone, uow)).clearDeferredChanges();
        }
    }

    public boolean isListOrderFieldSupported() {
        return this.isListOrderFieldSupported;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setListOrderField(DatabaseField field) {
        if (field != null) {
            if (!this.isListOrderFieldSupported) throw ValidationException.listOrderFieldNotSupported(this);
            this.listOrderField = field;
            return;
        } else {
            this.listOrderField = null;
        }
    }

    public void setListOrderFieldName(String fieldName) {
        this.setListOrderField(new DatabaseField(fieldName));
    }

    public void setMustDeleteReferenceObjectsOneByOne(Boolean deleteOneByOne) {
        this.mustDeleteReferenceObjectsOneByOne = deleteOneByOne;
    }

    public void setOrderCorrectionType(OrderCorrectionType orderCorrectionType) {
        this.orderCorrectionType = orderCorrectionType;
    }

    @Override
    public void useCollectionClass(Class concreteClass) {
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass, this.hasOrderBy() || this.listOrderField != null);
        this.setContainerPolicy(policy);
    }

    public void useSortedSetClass(Class concreteClass, Comparator comparator) {
        try {
            SortedCollectionContainerPolicy policy = (SortedCollectionContainerPolicy)ContainerPolicy.buildPolicyFor(concreteClass);
            policy.setComparator(comparator);
            this.setContainerPolicy(policy);
        }
        catch (ClassCastException classCastException) {
            this.useCollectionClass(concreteClass);
        }
    }

    public void useSortedSetClassName(String className) {
        this.useSortedSetClassName(className, null);
    }

    public void useSortedSetClassName(String className, String comparatorClassName) {
        SortedCollectionContainerPolicy policy = new SortedCollectionContainerPolicy(className);
        policy.setComparatorClassName(comparatorClassName);
        this.setContainerPolicy(policy);
    }

    @Override
    public void useCollectionClassName(String concreteClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteClassName));
    }

    @Override
    public void useListClassName(String concreteClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteClassName));
    }

    @Override
    public void useMapClass(Class concreteClass, String keyName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        policy.setKeyName(keyName, this.getReferenceClassName());
        this.setContainerPolicy(policy);
    }

    public void useMapClass(Class concreteClass) {
        this.useMapClass(concreteClass, null);
    }

    @Override
    public void useMapClassName(String concreteClassName, String methodName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy policy = new MapContainerPolicy(concreteClassName);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    public void useTransparentCollection() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
    }

    public void useTransparentSet() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(IndirectSet.class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(HashSet.class));
    }

    public void useTransparentList() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(Vector.class, this.hasOrderBy() || this.listOrderField != null));
    }

    public void useTransparentMap(String methodName) {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class, methodName);
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(Hashtable.class);
        policy.setKeyName(methodName, this.getReferenceClass());
        this.setSelectionQueryContainerPolicy(policy);
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        this.indirectionPolicy.validateContainerPolicy(session.getIntegrityChecker());
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.indirectionPolicy.validateDeclaredAttributeTypeForCollection(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.indirectionPolicy.validateGetMethodReturnTypeForCollection(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.indirectionPolicy.validateSetMethodParameterTypeForCollection(parameterType, session.getIntegrityChecker());
        }
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        if (this.isPrivateOwned() || this.isCascadeRemove()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.containerPolicy;
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        this.prepareTranslationRow(row, object, this.getDescriptor(), session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.containerPolicy.isEmpty(value);
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return this.indirectionPolicy.usesTransparentIndirection();
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        IdentityHashMap<Object, Object> cloneKeyValues = new IdentityHashMap<Object, Object>();
        ContainerPolicy cp = this.containerPolicy;
        Object cloneObjectCollection = null;
        cloneObjectCollection = cloneAttribute != null ? this.getRealCollectionAttributeValueFromObject(clone, session) : cp.containerInstance(1);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object firstObject = cp.next(cloneIter, session);
            if (firstObject == null) continue;
            cloneKeyValues.put(firstObject, firstObject);
        }
        CollectionChangeRecord changeRecord = new CollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues, cp, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    @Override
    public Object valueFromPKList(Object[] pks, AbstractRecord foreignKeys, AbstractSession session) {
        ContainerPolicy cp = this.containerPolicy;
        return cp.valueFromPKList(pks, foreignKeys, this, session);
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey parentCacheKey, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        Object value = this.containerPolicy.containerInstance();
        Object sourceKey = this.descriptor.getObjectBuilder().extractPrimaryKeyFromRow(row, executionSession);
        List<AbstractRecord> rows = joinManager.getDataResultsByPrimaryKey().get(sourceKey);
        if (rows == null) {
            return this.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
        }
        int size = rows.size();
        if (size > 0) {
            ObjectLevelReadQuery nestedQuery = this.prepareNestedJoinQueryClone(row, rows, joinManager, sourceQuery, executionSession);
            HashSet<Object> targetPrimaryKeys = new HashSet<Object>();
            ArrayList<Object> targetObjects = null;
            ArrayList<AbstractRecord> targetRows = null;
            boolean shouldAddAll = this.containerPolicy.shouldAddAll();
            if (shouldAddAll) {
                targetObjects = new ArrayList<Object>(size);
                targetRows = new ArrayList<AbstractRecord>(size);
            }
            int index = 0;
            while (index < size) {
                AbstractRecord sourceRow;
                AbstractRecord targetRow = sourceRow = rows.get(index);
                targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession);
                Object targetKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(targetRow, executionSession);
                if (targetKey == null) {
                    return this.indirectionPolicy.valueFromRow(value);
                }
                if (!targetPrimaryKeys.contains(targetKey)) {
                    nestedQuery.setTranslationRow(targetRow);
                    targetPrimaryKeys.add(targetKey);
                    Object targetObject = this.getReferenceDescriptor().getObjectBuilder().buildObject(nestedQuery, targetRow);
                    Object targetMapKey = this.containerPolicy.buildKeyFromJoinedRow(targetRow, joinManager, nestedQuery, parentCacheKey, executionSession, isTargetProtected);
                    nestedQuery.setTranslationRow(null);
                    if (targetMapKey == null) {
                        if (shouldAddAll) {
                            targetObjects.add(targetObject);
                            targetRows.add(targetRow);
                        } else {
                            this.containerPolicy.addInto(targetObject, value, executionSession);
                        }
                    } else {
                        this.containerPolicy.addInto(targetMapKey, targetObject, value, executionSession);
                    }
                }
                ++index;
            }
            if (shouldAddAll) {
                this.containerPolicy.addAll(targetObjects, value, executionSession, targetRows, nestedQuery, parentCacheKey, isTargetProtected);
            }
        }
        return this.indirectionPolicy.valueFromRow(value);
    }
}

