/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.aas.rest;

import eu.europeana.cloud.client.aas.rest.CloudException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASClient {
    private Client client = JerseyClientBuilder.newClient();
    private String aasUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(AASClient.class);

    public AASClient(String aasUrl, String username, String password) {
        LOGGER.info("AASClient starting...");
        this.client.register((Object)new HttpBasicAuthFilter(username, password));
        this.aasUrl = aasUrl;
        LOGGER.info("AASClient started successfully.");
    }

    public void createEcloudUser(String username, String password) throws CloudException {
        Response resp = this.client.target(this.aasUrl + "/create-user").queryParam("username", new Object[]{username}).queryParam("password", new Object[]{password}).request().post(null);
        System.out.println(resp);
        System.out.println(resp.getStatus());
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new RuntimeException("createEcloudUser() failed!");
        }
        LOGGER.debug("createEcloudUser: user {} is now part of ecloud", (Object)username);
    }

    public void updateEcloudUser(String username, String password) throws CloudException {
        Response resp = this.client.target(this.aasUrl + "/update-user").queryParam("username", new Object[]{username}).queryParam("password", new Object[]{password}).request().post(null);
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new RuntimeException("updateEcloudUser() failed!");
        }
        LOGGER.debug("updateEcloudUser: user {} updated!", (Object)username);
    }

    public void deleteEcloudUser(String username) throws CloudException {
        Response resp = this.client.target(this.aasUrl + "/delete-user").queryParam("username", new Object[]{username}).request().post(null);
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new RuntimeException("deleteEcloudUser() failed!");
        }
        LOGGER.debug("deleteEcloudUser: user {} deleted!", (Object)username);
    }
}

