/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import javax.inject.Singleton;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.monitoring.ApplicationEventImpl;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.AbstractContainerLifecycleListener;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class MonitoringContainerListener
extends AbstractContainerLifecycleListener {
    private volatile ApplicationEvent initFinishedEvent;
    private volatile ApplicationEventListener listener;

    public void init(ApplicationEventListener listener, ApplicationEvent initFinishedEvent) {
        this.listener = listener;
        this.initFinishedEvent = initFinishedEvent;
    }

    @Override
    public void onReload(Container container) {
        if (this.listener != null) {
            this.listener.onEvent(this.getApplicationEvent(ApplicationEvent.Type.RELOAD_FINISHED));
        }
    }

    private ApplicationEventImpl getApplicationEvent(ApplicationEvent.Type type) {
        return new ApplicationEventImpl(type, this.initFinishedEvent.getResourceConfig(), this.initFinishedEvent.getProviders(), this.initFinishedEvent.getRegisteredClasses(), this.initFinishedEvent.getRegisteredInstances(), this.initFinishedEvent.getResourceModel());
    }

    @Override
    public void onShutdown(Container container) {
        if (this.listener != null) {
            this.listener.onEvent(this.getApplicationEvent(ApplicationEvent.Type.DESTROY_FINISHED));
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(MonitoringContainerListener.class).to(MonitoringContainerListener.class).to(ContainerLifecycleListener.class).in(Singleton.class);
        }
    }
}

