/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.NamespaceWatchedEvent;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class NamespaceWatcher
implements Watcher {
    private final CuratorFrameworkImpl client;
    private final Watcher actualWatcher;
    private final CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl client, Watcher actualWatcher) {
        this.client = client;
        this.actualWatcher = actualWatcher;
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl client, CuratorWatcher curatorWatcher) {
        this.client = client;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
    }

    @Override
    public void process(WatchedEvent event) {
        if (this.actualWatcher != null) {
            this.actualWatcher.process(new NamespaceWatchedEvent(this.client, event));
        } else if (this.curatorWatcher != null) {
            try {
                this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, event));
            }
            catch (Exception e) {
                this.client.logError("Watcher exception", e);
            }
        }
    }
}

