/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.coordination.discovery;

import com.google.common.base.Throwables;
import eu.europeana.cloud.service.coordination.ServiceProperties;
import eu.europeana.cloud.service.coordination.ZookeeperService;
import eu.europeana.cloud.service.coordination.discovery.EcloudServiceDiscovery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperServiceDiscovery
implements EcloudServiceDiscovery {
    private final String serviceType;
    private final ServiceDiscovery<ServiceProperties> discovery;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperServiceDiscovery.class);
    private final ServiceCache<ServiceProperties> cache;

    public ZookeeperServiceDiscovery(ZookeeperService zookeeper, String discoveryPath, String serviceType) {
        this.serviceType = serviceType;
        JsonInstanceSerializer<ServiceProperties> instanceSerializer = new JsonInstanceSerializer<ServiceProperties>(ServiceProperties.class);
        this.discovery = ServiceDiscoveryBuilder.builder(ServiceProperties.class).basePath(zookeeper.getZookeeperPath() + discoveryPath).client(zookeeper.getClient()).serializer(instanceSerializer).build();
        this.cache = this.discovery.serviceCacheBuilder().name(serviceType).build();
        try {
            this.cache.start();
            this.discovery.start();
        }
        catch (Exception e) {
            LOGGER.error("ZookeeperServiceDiscovery error starting the service.. {}", (Object)e.getMessage());
            throw Throwables.propagate(e);
        }
    }

    @Override
    public List<ServiceProperties> getServices() {
        try {
            ServiceProvider<ServiceProperties> serviceProvider = this.discovery.serviceProviderBuilder().serviceName(this.serviceType).build();
            serviceProvider.start();
            Collection<ServiceInstance<ServiceProperties>> serviceInstances = serviceProvider.getAllInstances();
            ArrayList<ServiceProperties> services = new ArrayList<ServiceProperties>();
            Iterator<ServiceInstance<ServiceProperties>> i = serviceInstances.iterator();
            while (i.hasNext()) {
                services.add(i.next().getPayload());
            }
            return services;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw Throwables.propagate(e);
        }
    }

    private Collection<ServiceInstance<ServiceProperties>> getServiceInstances(String serviceName) {
        Collection<ServiceInstance<ServiceProperties>> instances;
        try {
            instances = this.discovery.queryForInstances(serviceName);
            int servicesDiscoveredCount = instances.size();
            LOGGER.info("Found '{}' services: {} .", (Object)servicesDiscoveredCount, (Object)instances);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw Throwables.propagate(e);
        }
        return instances;
    }
}

