/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.coordination.configuration;

import com.google.common.io.Closeables;
import eu.europeana.cloud.service.coordination.ZookeeperService;
import eu.europeana.cloud.service.coordination.configuration.DynamicPropertyListener;
import eu.europeana.cloud.service.coordination.configuration.DynamicPropertyManager;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDynamicPropertyManager
implements DynamicPropertyManager,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperDynamicPropertyManager.class);
    private final CuratorFramework client;
    private final String configRootPath;
    private final PathChildrenCache pathChildrenCache;
    private final Charset charset = Charset.forName("UTF-8");
    private ConcurrentMap<String, DynamicPropertyListener> listeners = new ConcurrentHashMap<String, DynamicPropertyListener>();

    public ZookeeperDynamicPropertyManager(ZookeeperService zookeeperService, String configRootPath) {
        this.client = zookeeperService.getClient();
        this.configRootPath = configRootPath;
        this.pathChildrenCache = new PathChildrenCache(this.client, configRootPath, true);
        try {
            this.start();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void start() throws Exception {
        this.pathChildrenCache.getListenable().addListener(new PathChildrenCacheListener(){

            @Override
            public void childEvent(CuratorFramework aClient, PathChildrenCacheEvent event) throws Exception {
                PathChildrenCacheEvent.Type eventType = event.getType();
                ChildData data = event.getData();
                String path = null;
                if (data != null) {
                    path = data.getPath();
                    String key = ZookeeperDynamicPropertyManager.this.removeRootPath(path);
                    byte[] value = data.getData();
                    String stringValue = new String(value, ZookeeperDynamicPropertyManager.this.charset);
                    LOGGER.debug("received update to pathName [{}], eventType [{}]", (Object)path, (Object)eventType);
                    LOGGER.debug("key [{}], and value [{}]", (Object)key, (Object)stringValue);
                    HashMap<String, Object> added = null;
                    HashMap<String, Object> changed = null;
                    HashMap<String, Object> deleted = null;
                    if (eventType == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                        added = new HashMap<String, Object>(1);
                        added.put(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                        changed = new HashMap<String, Object>(1);
                        changed.put(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                        deleted = new HashMap<String, Object>(1);
                        deleted.put(key, stringValue);
                    }
                    ZookeeperDynamicPropertyManager.this.fireEvent(added);
                    ZookeeperDynamicPropertyManager.this.fireEvent(changed);
                    ZookeeperDynamicPropertyManager.this.fireEvent(deleted);
                }
            }
        });
        this.pathChildrenCache.start(PathChildrenCache.StartMode.NORMAL);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        LOGGER.debug("getCurrentData() retrieving current data.");
        List<ChildData> children = this.pathChildrenCache.getCurrentData();
        HashMap<String, Object> all = new HashMap<String, Object>(children.size());
        for (ChildData child : children) {
            String path = child.getPath();
            String key = this.removeRootPath(path);
            byte[] value = child.getData();
            all.put(key, new String(value, this.charset));
        }
        LOGGER.debug("getCurrentData() retrieved [{}] config elements.", (Object)children.size());
        return all;
    }

    @Override
    public void addUpdateListener(DynamicPropertyListener l, String dynamicProperty) {
        if (l != null) {
            this.listeners.put(dynamicProperty, l);
        }
    }

    @Override
    public void removeUpdateListener(DynamicPropertyListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    protected void fireEvent(Map<String, Object> updatedProperties) {
        if (updatedProperties == null) {
            return;
        }
        for (String dynamicProperty : this.listeners.keySet()) {
            Object dynamicPropertyValue = updatedProperties.get(dynamicProperty);
            if (dynamicPropertyValue == null) continue;
            ((DynamicPropertyListener)this.listeners.get(dynamicProperty)).onUpdate((String)dynamicPropertyValue);
        }
    }

    private String removeRootPath(String nodePath) {
        return nodePath.replace(this.configRootPath + "/", "");
    }

    synchronized void setZkProperty(String key, String value) throws Exception {
        String path = this.configRootPath + "/" + key;
        byte[] data = value.getBytes(this.charset);
        try {
            this.client.create().creatingParentsIfNeeded().forPath(path, data);
        }
        catch (KeeperException.NodeExistsException exc) {
            this.client.setData().forPath(path, data);
        }
    }

    synchronized String getZkProperty(String key) throws Exception {
        String path = this.configRootPath + "/" + key;
        byte[] bytes = (byte[])this.client.getData().forPath(path);
        return new String(bytes, this.charset);
    }

    synchronized void deleteZkProperty(String key) throws Exception {
        String path = this.configRootPath + "/" + key;
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException exc) {
            LOGGER.warn("Node doesn't exist", exc);
        }
    }

    @Override
    public void close() {
        try {
            Closeables.close(this.pathChildrenCache, true);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    @Override
    public void updateValue(String dynamicProperty, String dynamicPropertyUpdatedValue) {
        try {
            this.setZkProperty(dynamicProperty, dynamicPropertyUpdatedValue);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    @Override
    public String getCurrentValue(String dynamicProperty) {
        try {
            return this.getZkProperty(dynamicProperty);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }
}

