/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.aas.acl.model;

import java.io.Serializable;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.util.Assert;

public class AclObjectIdentity {
    private String id;
    private String objectClass;
    private String parentObjectId;
    private String parentObjectClass;
    private String ownerId;
    private boolean ownerPrincipal;
    private boolean entriesInheriting;

    public AclObjectIdentity() {
    }

    public AclObjectIdentity(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        this.objectClass = objectIdentity.getType();
        this.id = (String)((Object)objectIdentity.getIdentifier());
    }

    public AclObjectIdentity(Acl acl) {
        Assert.notNull((Object)acl, (String)"Acl required");
        this.entriesInheriting = acl.isEntriesInheriting();
        this.id = (String)((Object)acl.getObjectIdentity().getIdentifier());
        this.objectClass = acl.getObjectIdentity().getType();
        if (acl.getOwner() instanceof PrincipalSid) {
            this.ownerId = ((PrincipalSid)acl.getOwner()).getPrincipal();
            this.ownerPrincipal = true;
        } else if (acl.getOwner() instanceof GrantedAuthoritySid) {
            this.ownerId = ((GrantedAuthoritySid)acl.getOwner()).getGrantedAuthority();
            this.ownerPrincipal = false;
        }
        this.parentObjectId = acl.getParentAcl() != null ? (String)((Object)acl.getParentAcl().getObjectIdentity().getIdentifier()) : null;
        this.parentObjectClass = acl.getParentAcl() != null ? acl.getParentAcl().getObjectIdentity().getType() : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public boolean isOwnerPrincipal() {
        return this.ownerPrincipal;
    }

    public void setOwnerPrincipal(boolean ownerPrincipal) {
        this.ownerPrincipal = ownerPrincipal;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getParentObjectId() {
        return this.parentObjectId;
    }

    public void setParentObjectId(String parentObjectId) {
        this.parentObjectId = parentObjectId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Sid getOwnerSid() {
        Object result = null;
        result = this.ownerPrincipal ? new PrincipalSid(this.ownerId) : new GrantedAuthoritySid(this.ownerId);
        return result;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.entriesInheriting = entriesInheriting;
    }

    public String getParentObjectClass() {
        return this.parentObjectClass;
    }

    public ObjectIdentity getParentObjectIdentity() {
        if (this.parentObjectClass != null && this.parentObjectId != null) {
            return new ObjectIdentityImpl(this.parentObjectClass, (Serializable)((Object)this.parentObjectId));
        }
        return null;
    }

    public void setParentObjectClass(String parentObjectClass) {
        this.parentObjectClass = parentObjectClass;
    }

    public ObjectIdentity toObjectIdentity() {
        return new ObjectIdentityImpl(this.objectClass, (Serializable)((Object)this.id));
    }

    public String getRowId() {
        return this.objectClass + ":" + this.id;
    }

    public String getParentRowId() {
        if (this.parentObjectId != null && this.parentObjectClass != null) {
            return this.parentObjectClass + ":" + this.parentObjectId;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclObjectIdentity [").append("id: ").append(this.id);
        sb.append(", objectClass: ").append(this.objectClass);
        sb.append(", parentObjectId: ").append(this.parentObjectId);
        sb.append(", parentObjectClass: ").append(this.parentObjectClass);
        sb.append(", ownerId: ").append(this.ownerId);
        sb.append(", ownerPrincipal: ").append(this.ownerPrincipal);
        sb.append(", entriesInheriting: ").append(this.entriesInheriting).append(']');
        return sb.toString();
    }
}

