/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.aas.acl.model;

import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AuditableAccessControlEntry;
import org.springframework.security.acls.model.Sid;

public class AclEntry {
    private String id;
    private String sid;
    private boolean sidPrincipal;
    private int order;
    private int mask;
    private boolean granting;
    private boolean auditSuccess;
    private boolean auditFailure;

    public AclEntry() {
    }

    public AclEntry(AccessControlEntry ace) {
        this.granting = ace.isGranting();
        this.id = (String)((Object)ace.getId());
        this.mask = ace.getPermission().getMask();
        this.order = ace.getAcl().getEntries().indexOf(ace);
        if (ace.getSid() instanceof PrincipalSid) {
            this.sid = ((PrincipalSid)ace.getSid()).getPrincipal();
            this.sidPrincipal = true;
        } else if (ace.getSid() instanceof GrantedAuthoritySid) {
            this.sid = ((GrantedAuthoritySid)ace.getSid()).getGrantedAuthority();
            this.sidPrincipal = false;
        }
        if (ace instanceof AuditableAccessControlEntry) {
            this.auditSuccess = ((AuditableAccessControlEntry)ace).isAuditFailure();
            this.auditFailure = ((AuditableAccessControlEntry)ace).isAuditSuccess();
        } else {
            this.auditSuccess = false;
            this.auditFailure = false;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSidPrincipal() {
        return this.sidPrincipal;
    }

    public void setSidPrincipal(boolean sidPrincipal) {
        this.sidPrincipal = sidPrincipal;
    }

    public String getSid() {
        return this.sid;
    }

    public Sid getSidObject() {
        Object result = null;
        result = this.sidPrincipal ? new PrincipalSid(this.sid) : new GrantedAuthoritySid(this.sid);
        return result;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public boolean isGranting() {
        return this.granting;
    }

    public void setGranting(boolean granting) {
        this.granting = granting;
    }

    public boolean isAuditSuccess() {
        return this.auditSuccess;
    }

    public void setAuditSuccess(boolean auditSuccess) {
        this.auditSuccess = auditSuccess;
    }

    public boolean isAuditFailure() {
        return this.auditFailure;
    }

    public void setAuditFailure(boolean auditFailure) {
        this.auditFailure = auditFailure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclEntry [").append("id: ").append(this.id);
        sb.append(", sid: ").append(this.sid);
        sb.append(", sidPrincipal: ").append(this.sidPrincipal);
        sb.append(", order: ").append(this.order);
        sb.append(", mask: ").append(this.mask);
        sb.append(", granting: ").append(this.granting);
        sb.append(", auditSuccess: ").append(this.auditSuccess);
        sb.append(", auditFailure: ").append(this.auditFailure).append(']');
        return sb.toString();
    }
}

