/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.aas.acl;

import eu.europeana.aas.acl.CassandraAclService;
import eu.europeana.aas.acl.model.AclEntry;
import eu.europeana.aas.acl.model.AclObjectIdentity;
import eu.europeana.aas.acl.repository.AclRepository;
import eu.europeana.aas.acl.repository.exceptions.AclAlreadyExistsException;
import eu.europeana.aas.acl.repository.exceptions.AclNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class CassandraMutableAclService
extends CassandraAclService
implements MutableAclService {
    private static final Log LOG = LogFactory.getLog(CassandraMutableAclService.class);

    public CassandraMutableAclService(AclRepository aclRepository, AclCache aclCache, PermissionGrantingStrategy grantingStrategy, AclAuthorizationStrategy aclAuthorizationStrategy, PermissionFactory permissionFactory) {
        super(aclRepository, aclCache, grantingStrategy, aclAuthorizationStrategy, permissionFactory);
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN createAcl: objectIdentity: " + objectIdentity));
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        AclObjectIdentity newAoi = new AclObjectIdentity(objectIdentity);
        newAoi.setOwnerId(sid.getPrincipal());
        newAoi.setOwnerPrincipal(true);
        newAoi.setEntriesInheriting(false);
        try {
            this.aclRepository.saveAcl(newAoi);
        }
        catch (AclAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage(), (Throwable)e);
        }
        Acl acl = this.readAclById(objectIdentity);
        Assert.isInstanceOf(MutableAcl.class, (Object)acl, (String)"MutableAcl should be been returned");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END createAcl: acl: " + acl));
        }
        return (MutableAcl)acl;
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)objectIdentity.getIdentifier(), (String)"Object Identity doesn't provide an identifier");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN deleteAcl: objectIdentity: " + objectIdentity + ", deleteChildren: " + deleteChildren));
        }
        ArrayList<ObjectIdentity> objectsToDelete = new ArrayList<ObjectIdentity>();
        objectsToDelete.add(objectIdentity);
        List<ObjectIdentity> children = this.findChildren(objectIdentity);
        if (deleteChildren) {
            for (ObjectIdentity child : children) {
                objectsToDelete.addAll(this.calculateChildrenReccursively(child));
            }
        } else if (children != null && !children.isEmpty()) {
            throw new ChildrenExistException("Cannot delete '" + objectIdentity + "' (has " + children.size() + " children)");
        }
        ArrayList<AclObjectIdentity> objIdsToDelete = new ArrayList<AclObjectIdentity>(objectsToDelete.size());
        for (ObjectIdentity objId : objectsToDelete) {
            objIdsToDelete.add(new AclObjectIdentity(objId));
        }
        this.aclRepository.deleteAcls(objIdsToDelete);
        if (this.aclCache != null) {
            for (ObjectIdentity obj : objectsToDelete) {
                this.aclCache.evictFromCache(obj);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"END deleteAcl");
        }
    }

    public MutableAcl updateAcl(MutableAcl acl) throws NotFoundException {
        Assert.notNull((Object)acl, (String)"MutableAcl required");
        Assert.notNull((Object)acl.getObjectIdentity(), (String)"Object Identity required");
        Assert.notNull((Object)acl.getObjectIdentity().getIdentifier(), (String)"Object Identity doesn't provide an identifier");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN updateAcl: acl: " + acl));
        }
        try {
            this.aclRepository.updateAcl(new AclObjectIdentity((Acl)acl), this.convertToAclEntries((Acl)acl));
        }
        catch (AclNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        this.clearCacheIncludingChildren(acl.getObjectIdentity());
        MutableAcl result = (MutableAcl)this.readAclById(acl.getObjectIdentity());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END updateAcl: acl: " + result));
        }
        return result;
    }

    private List<ObjectIdentity> calculateChildrenReccursively(ObjectIdentity rootChild) {
        ArrayList<ObjectIdentity> result = new ArrayList<ObjectIdentity>();
        result.add(rootChild);
        List<ObjectIdentity> children = this.findChildren(rootChild);
        if (children != null) {
            for (ObjectIdentity child : children) {
                result.addAll(this.calculateChildrenReccursively(child));
            }
        }
        return result;
    }

    private List<AclEntry> convertToAclEntries(Acl acl) {
        ArrayList<AclEntry> result = new ArrayList<AclEntry>(acl.getEntries().size());
        for (AccessControlEntry entry : acl.getEntries()) {
            result.add(new AclEntry(entry));
        }
        return result;
    }

    private void clearCacheIncludingChildren(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        List<ObjectIdentity> children = this.findChildren(objectIdentity);
        if (children != null) {
            for (ObjectIdentity child : children) {
                this.clearCacheIncludingChildren(child);
            }
        }
        if (this.aclCache != null) {
            this.aclCache.evictFromCache(objectIdentity);
        }
    }
}

