/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.aas.acl;

import eu.europeana.aas.acl.model.AclEntry;
import eu.europeana.aas.acl.model.AclObjectIdentity;
import eu.europeana.aas.acl.repository.AclRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public class CassandraAclService
implements AclService {
    private static final Log LOG = LogFactory.getLog(CassandraAclService.class);
    protected final AclRepository aclRepository;
    protected final AclCache aclCache;
    private final PermissionFactory permissionFactory;
    private final AclAuthorizationStrategy aclAuthorizationStrategy;
    private final PermissionGrantingStrategy grantingStrategy;
    private final Field fieldAces = FieldUtils.getField(AclImpl.class, (String)"aces");

    public CassandraAclService(AclRepository aclRepository, AclCache aclCache, PermissionGrantingStrategy grantingStrategy, AclAuthorizationStrategy aclAuthorizationStrategy, PermissionFactory permissionFactory) {
        this.aclRepository = aclRepository;
        this.aclCache = aclCache;
        this.grantingStrategy = grantingStrategy;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.permissionFactory = permissionFactory;
        this.fieldAces.setAccessible(true);
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        Assert.notNull((Object)parentIdentity, (String)"Object to lookup required");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN findChildren: parentIdentity: " + parentIdentity));
        }
        ArrayList<ObjectIdentity> result = null;
        List<AclObjectIdentity> children = this.aclRepository.findAclObjectIdentityChildren(new AclObjectIdentity(parentIdentity));
        if (children != null && !children.isEmpty()) {
            result = new ArrayList<ObjectIdentity>(children.size());
            for (AclObjectIdentity entry : children) {
                result.add(entry.toObjectIdentity());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END findChildren: children: " + result));
        }
        return result;
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> map = this.readAclsById(Arrays.asList(object), sids);
        Assert.isTrue((boolean)map.containsKey(object), (String)("There should have been an Acl entry for ObjectIdentity " + object));
        return map.get(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects, List<Sid> sids) throws NotFoundException {
        Assert.notEmpty(objects, (String)"Objects to lookup required");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN readAclById: objectIdentities: " + objects + ", sids: " + sids));
        }
        HashMap<ObjectIdentity, Acl> result = new HashMap<ObjectIdentity, Acl>();
        ArrayList<ObjectIdentity> objectsToLookup = new ArrayList<ObjectIdentity>(objects);
        if (this.aclCache != null) {
            for (ObjectIdentity objectIdentity : objects) {
                boolean aclLoaded = false;
                MutableAcl acl = this.aclCache.getFromCache(objectIdentity);
                if (acl != null && acl.isSidLoaded(sids)) {
                    result.put(objectIdentity, (Acl)acl);
                    aclLoaded = true;
                }
                if (!aclLoaded) continue;
                objectsToLookup.remove(objectIdentity);
            }
        }
        if (!objectsToLookup.isEmpty()) {
            Map<ObjectIdentity, Acl> loadedAcls = this.doLookup(objectsToLookup);
            result.putAll(loadedAcls);
            if (this.aclCache != null) {
                for (Acl loadedAcl : loadedAcls.values()) {
                    this.aclCache.putInCache((MutableAcl)((AclImpl)loadedAcl));
                }
            }
        }
        for (ObjectIdentity objectIdentity : objects) {
            if (result.containsKey(objectIdentity)) continue;
            throw new NotFoundException("Unable to find ACL information for object identity '" + objectIdentity + "'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END readAclById: acls: " + result.values()));
        }
        return result;
    }

    private Map<ObjectIdentity, Acl> doLookup(List<ObjectIdentity> objects) {
        HashMap<ObjectIdentity, Acl> result = new HashMap<ObjectIdentity, Acl>();
        if (objects != null && !objects.isEmpty()) {
            ArrayList<AclObjectIdentity> objectIds = new ArrayList<AclObjectIdentity>(objects.size());
            for (ObjectIdentity objId : objects) {
                objectIds.add(new AclObjectIdentity(objId));
            }
            Map<AclObjectIdentity, Set<AclEntry>> aeList = this.aclRepository.findAcls(objectIds);
            Map<ObjectIdentity, Acl> parentAcls = this.lookupParents(aeList.keySet());
            for (Map.Entry<AclObjectIdentity, Set<AclEntry>> entry : aeList.entrySet()) {
                Acl parentAcl = parentAcls.get(entry.getKey().getParentObjectIdentity());
                AclImpl loadedAcl = this.convert(entry.getKey(), entry.getValue(), parentAcl);
                result.put(loadedAcl.getObjectIdentity(), (Acl)loadedAcl);
            }
        }
        return result;
    }

    private Map<ObjectIdentity, Acl> lookupParents(Set<AclObjectIdentity> acls) {
        ArrayList<ObjectIdentity> objectsToLookup = new ArrayList<ObjectIdentity>();
        for (AclObjectIdentity aoi : acls) {
            if (aoi.getParentObjectId() == null || aoi.getParentObjectId().isEmpty() || aoi.getParentObjectClass() == null || aoi.getParentObjectClass().isEmpty()) continue;
            objectsToLookup.add((ObjectIdentity)new ObjectIdentityImpl(aoi.getParentObjectClass(), (Serializable)((Object)aoi.getParentObjectId())));
        }
        return this.doLookup(objectsToLookup);
    }

    private AclImpl convert(AclObjectIdentity aclObjectIdentity, Set<AclEntry> aclEntries, Acl parentAcl) {
        AclImpl acl = new AclImpl(aclObjectIdentity.toObjectIdentity(), (Serializable)((Object)aclObjectIdentity.getId()), this.aclAuthorizationStrategy, this.grantingStrategy, parentAcl, null, aclObjectIdentity.isEntriesInheriting(), aclObjectIdentity.getOwnerSid());
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>(aclEntries.size());
        for (AclEntry entry : aclEntries) {
            AccessControlEntryImpl ace = new AccessControlEntryImpl((Serializable)((Object)entry.getId()), (Acl)acl, entry.getSidObject(), this.permissionFactory.buildFromMask(entry.getMask()), entry.isGranting(), entry.isAuditSuccess(), entry.isAuditFailure());
            aces.add(entry.getOrder(), ace);
        }
        try {
            this.fieldAces.set(acl, aces);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not set AccessControlEntries in the ACL", (Throwable)e);
        }
        return acl;
    }
}

