/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.aas.acl.repository;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import eu.europeana.aas.acl.model.AclEntry;
import eu.europeana.aas.acl.model.AclObjectIdentity;
import eu.europeana.aas.acl.repository.AclRepository;
import eu.europeana.aas.acl.repository.exceptions.AclAlreadyExistsException;
import eu.europeana.aas.acl.repository.exceptions.AclNotFoundException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public final class CassandraAclRepository
implements AclRepository {
    private static final Log LOG = LogFactory.getLog(CassandraAclRepository.class);
    private static final String AOI_TABLE = "aois";
    private static final String CHILDREN_TABLE = "children";
    private static final String ACL_TABLE = "acls";
    private static final String[] AOI_KEYS = new String[]{"id", "objId", "objClass", "isInheriting", "owner", "isOwnerPrincipal", "parentObjId", "parentObjClass"};
    private static final String[] CHILD_KEYS = new String[]{"id", "childId", "objId", "objClass"};
    private static final String[] ACL_KEYS = new String[]{"id", "aclOrder", "sid", "mask", "isSidPrincipal", "isGranting", "isAuditSuccess", "isAuditFailure"};
    private final Session session;
    private final String keyspace;

    public CassandraAclRepository(CassandraConnectionProvider provider, boolean initSchema) {
        this(provider.getSession(), provider.getKeyspaceName(), initSchema);
    }

    public CassandraAclRepository(Session session, String keyspace) {
        this.session = session;
        this.keyspace = keyspace;
    }

    public CassandraAclRepository(Session session, String keyspace, boolean initSchema) {
        this(session, keyspace);
        if (initSchema) {
            this.createAoisTable();
            this.createChilrenTable();
            this.createAclsTable();
        }
    }

    @Override
    public Map<AclObjectIdentity, Set<AclEntry>> findAcls(List<AclObjectIdentity> objectIdsToLookup) {
        this.assertAclObjectIdentityList(objectIdsToLookup);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN findAcls: objectIdentities: " + objectIdsToLookup));
        }
        HashMap<AclObjectIdentity, Set<AclEntry>> resultMap = new HashMap<AclObjectIdentity, Set<AclEntry>>();
        ArrayList<String> ids = new ArrayList<String>();
        for (AclObjectIdentity entry : objectIdsToLookup) {
            ids.add(entry.getRowId());
        }
        ResultSet resultSet = this.session.execute(QueryBuilder.select().all().from(this.keyspace, AOI_TABLE).where(QueryBuilder.in((String)"id", (Object[])ids.toArray())).setConsistencyLevel(ConsistencyLevel.QUORUM));
        for (Row row : resultSet.all()) {
            resultMap.put(this.convertToAclObjectIdentity(row, true), new TreeSet<AclEntry>(new Comparator<AclEntry>(){

                @Override
                public int compare(AclEntry o1, AclEntry o2) {
                    return new Integer(o1.getOrder()).compareTo(o2.getOrder());
                }
            }));
        }
        resultSet = this.session.execute(QueryBuilder.select().all().from(this.keyspace, ACL_TABLE).where(QueryBuilder.in((String)"id", (Object[])ids.toArray())).setConsistencyLevel(ConsistencyLevel.QUORUM));
        block2: for (Row row : resultSet.all()) {
            String aoiId = row.getString("id");
            AclEntry aclEntry = new AclEntry();
            aclEntry.setAuditFailure(row.getBool("isAuditFailure"));
            aclEntry.setAuditSuccess(row.getBool("isAuditSuccess"));
            aclEntry.setGranting(row.getBool("isGranting"));
            aclEntry.setMask(row.getInt("mask"));
            aclEntry.setOrder(row.getInt("aclOrder"));
            aclEntry.setSid(row.getString("sid"));
            aclEntry.setSidPrincipal(row.getBool("isSidPrincipal"));
            aclEntry.setId(aoiId + ":" + aclEntry.getSid() + ":" + aclEntry.getOrder());
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((AclObjectIdentity)entry.getKey()).getRowId().equals(aoiId)) continue;
                ((Set)entry.getValue()).add(aclEntry);
                continue block2;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END findAcls: objectIdentities: " + resultMap.keySet() + ", aclEntries: " + resultMap.values()));
        }
        return resultMap;
    }

    @Override
    public AclObjectIdentity findAclObjectIdentity(AclObjectIdentity objectId) {
        this.assertAclObjectIdentity(objectId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN findAclObjectIdentity: objectIdentity: " + objectId));
        }
        Row row = this.session.execute(QueryBuilder.select().all().from(this.keyspace, AOI_TABLE).where(QueryBuilder.eq((String)"id", (Object)objectId.getRowId())).setConsistencyLevel(ConsistencyLevel.QUORUM)).one();
        AclObjectIdentity objectIdentity = this.convertToAclObjectIdentity(row, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END findAclObjectIdentity: objectIdentity: " + objectIdentity));
        }
        return objectIdentity;
    }

    @Override
    public List<AclObjectIdentity> findAclObjectIdentityChildren(AclObjectIdentity objectId) {
        this.assertAclObjectIdentity(objectId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN findAclObjectIdentityChildren: objectIdentity: " + objectId));
        }
        ArrayList<AclObjectIdentity> result = new ArrayList<AclObjectIdentity>();
        ResultSet resultSet = this.session.execute(QueryBuilder.select().all().from(this.keyspace, CHILDREN_TABLE).where(QueryBuilder.eq((String)"id", (Object)objectId.getRowId())).setConsistencyLevel(ConsistencyLevel.QUORUM));
        for (Row row : resultSet.all()) {
            result.add(this.convertToAclObjectIdentity(row, false));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("END findAclObjectIdentityChildren: children: " + result));
        }
        return result;
    }

    @Override
    public void deleteAcls(List<AclObjectIdentity> objectIdsToDelete) {
        this.assertAclObjectIdentityList(objectIdsToDelete);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN deleteAcls: objectIdsToDelete: " + objectIdsToDelete));
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (AclObjectIdentity entry : objectIdsToDelete) {
            ids.add(entry.getRowId());
        }
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        batch.add((RegularStatement)QueryBuilder.delete().all().from(this.keyspace, AOI_TABLE).where(QueryBuilder.in((String)"id", (Object[])ids.toArray())));
        batch.add((RegularStatement)QueryBuilder.delete().all().from(this.keyspace, CHILDREN_TABLE).where(QueryBuilder.in((String)"id", (Object[])ids.toArray()))).setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.session.execute((Statement)batch);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"END deleteAcls");
        }
    }

    @Override
    public void saveAcl(AclObjectIdentity aoi) throws AclAlreadyExistsException {
        this.assertAclObjectIdentity(aoi);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN saveAcl: aclObjectIdentity: " + aoi));
        }
        if (this.findAclObjectIdentity(aoi) != null) {
            throw new AclAlreadyExistsException("Object identity '" + aoi + "' already exists");
        }
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        batch.add((RegularStatement)QueryBuilder.insertInto((String)this.keyspace, (String)AOI_TABLE).values(AOI_KEYS, new Object[]{aoi.getRowId(), aoi.getId(), aoi.getObjectClass(), aoi.isEntriesInheriting(), aoi.getOwnerId(), aoi.isOwnerPrincipal(), aoi.getParentObjectId(), aoi.getParentObjectClass()})).setConsistencyLevel(ConsistencyLevel.QUORUM);
        if (aoi.getParentRowId() != null) {
            batch.add((RegularStatement)QueryBuilder.insertInto((String)this.keyspace, (String)CHILDREN_TABLE).values(CHILD_KEYS, new Object[]{aoi.getParentRowId(), aoi.getRowId(), aoi.getId(), aoi.getObjectClass()})).setConsistencyLevel(ConsistencyLevel.QUORUM);
        }
        this.session.execute((Statement)batch);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"END saveAcl");
        }
    }

    @Override
    public void updateAcl(AclObjectIdentity aoi, List<AclEntry> entries) throws AclNotFoundException {
        AclObjectIdentity persistedAoi;
        this.assertAclObjectIdentity(aoi);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEGIN updateAcl: aclObjectIdentity: " + aoi + ", entries: " + entries));
        }
        if ((persistedAoi = this.findAclObjectIdentity(aoi)) == null) {
            throw new AclNotFoundException("Object identity '" + aoi + "' does not exist");
        }
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        batch.add((RegularStatement)QueryBuilder.insertInto((String)this.keyspace, (String)AOI_TABLE).values(AOI_KEYS, new Object[]{aoi.getRowId(), aoi.getId(), aoi.getObjectClass(), aoi.isEntriesInheriting(), aoi.getOwnerId(), aoi.isOwnerPrincipal(), aoi.getParentObjectId(), aoi.getParentObjectClass()}));
        batch.add((RegularStatement)QueryBuilder.delete().all().from(this.keyspace, ACL_TABLE).where(QueryBuilder.eq((String)"id", (Object)aoi.getRowId())));
        boolean parentChanged = false;
        if (!(persistedAoi.getParentRowId() != null ? persistedAoi.getParentRowId().equals(aoi.getParentRowId()) : aoi.getParentRowId() == null)) {
            parentChanged = true;
            if (persistedAoi.getParentRowId() != null) {
                batch.add((RegularStatement)QueryBuilder.delete().all().from(this.keyspace, CHILDREN_TABLE).where(QueryBuilder.eq((String)"id", (Object)persistedAoi.getParentRowId())).and(QueryBuilder.eq((String)"childId", (Object)aoi.getRowId()))).setConsistencyLevel(ConsistencyLevel.QUORUM);
            }
        }
        this.session.execute((Statement)batch);
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        boolean executeBatch = false;
        if (entries != null && !entries.isEmpty()) {
            for (AclEntry entry : entries) {
                batch.add((RegularStatement)QueryBuilder.insertInto((String)this.keyspace, (String)ACL_TABLE).values(ACL_KEYS, new Object[]{aoi.getRowId(), entry.getOrder(), entry.getSid(), entry.getMask(), entry.isSidPrincipal(), entry.isGranting(), entry.isAuditSuccess(), entry.isAuditFailure()}));
            }
            executeBatch = true;
        }
        if (parentChanged) {
            if (aoi.getParentRowId() != null) {
                batch.add((RegularStatement)QueryBuilder.insertInto((String)this.keyspace, (String)CHILDREN_TABLE).values(CHILD_KEYS, new Object[]{aoi.getParentRowId(), aoi.getRowId(), aoi.getId(), aoi.getObjectClass()})).setConsistencyLevel(ConsistencyLevel.QUORUM);
            }
            executeBatch = true;
        }
        if (executeBatch) {
            this.session.execute((Statement)batch);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"END updateAcl");
        }
    }

    private void assertAclObjectIdentityList(List<AclObjectIdentity> aoiList) {
        Assert.notEmpty(aoiList, (String)"The AclObjectIdentity list cannot be empty");
        for (AclObjectIdentity aoi : aoiList) {
            this.assertAclObjectIdentity(aoi);
        }
    }

    private void assertAclObjectIdentity(AclObjectIdentity aoi) {
        Assert.notNull((Object)aoi, (String)"The AclObjectIdentity cannot be null");
        Assert.notNull((Object)aoi.getId(), (String)"The AclObjectIdentity id cannot be null");
        Assert.notNull((Object)aoi.getObjectClass(), (String)"The AclObjectIdentity objectClass cannot be null");
    }

    private AclObjectIdentity convertToAclObjectIdentity(Row row, boolean fullObject) {
        AclObjectIdentity result = null;
        if (row != null) {
            result = new AclObjectIdentity();
            result.setId(row.getString("objId"));
            result.setObjectClass(row.getString("objClass"));
            if (fullObject) {
                result.setOwnerId(row.getString("owner"));
                result.setEntriesInheriting(row.getBool("isInheriting"));
                result.setOwnerPrincipal(row.getBool("isOwnerPrincipal"));
                result.setParentObjectClass(row.getString("parentObjClass"));
                result.setParentObjectId(row.getString("parentObjId"));
            }
        }
        return result;
    }

    public void createAoisTable() {
        try {
            this.session.execute("CREATE TABLE aois (id varchar PRIMARY KEY,objId varchar,objClass varchar,isInheriting boolean,owner varchar,isOwnerPrincipal boolean,parentObjId varchar,parentObjClass varchar);");
        }
        catch (AlreadyExistsException e) {
            LOG.warn((Object)e);
        }
    }

    public void createChilrenTable() {
        try {
            this.session.execute("CREATE TABLE children (id varchar,childId varchar,objId varchar,objClass varchar,PRIMARY KEY (id, childId));");
        }
        catch (AlreadyExistsException e) {
            LOG.warn((Object)e);
        }
    }

    public void createAclsTable() {
        try {
            this.session.execute("CREATE TABLE acls (id varchar,sid varchar,aclOrder int,mask int,isSidPrincipal boolean,isGranting boolean,isAuditSuccess boolean,isAuditFailure boolean,PRIMARY KEY (id, sid, aclOrder));");
        }
        catch (AlreadyExistsException e) {
            LOG.warn((Object)e);
        }
    }
}

