/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication.status;

import eu.europeana.cloud.common.exceptions.GenericException;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidPasswordException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidUsernameException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import jakarta.ws.rs.core.Response;

public enum IdentifierErrorTemplate {
    GENERIC_ERROR{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("GENERIC_ERROR", String.format("Unspecified Error occured with message %s", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }

        public GenericException getException(ErrorInfo e) {
            return new GenericException(e);
        }
    }
    ,
    DATABASE_CONNECTION_ERROR{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("DATABASE_CONNECTION_ERROR", String.format("The connection to the DB %s/%s failed with error %s", args[0], args[1], args[2]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }

        public DatabaseConnectionException getException(ErrorInfo e) {
            return new DatabaseConnectionException(e);
        }
    }
    ,
    USER_EXISTS{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("USER_EXISTS", String.format("A user %s already exists in the database", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public UserExistsException getException(ErrorInfo e) {
            return new UserExistsException(e);
        }
    }
    ,
    USER_DOES_NOT_EXIST{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("USER_DOES_NOT_EXIST", String.format("A user %s does not exist in the database", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public UserDoesNotExistException getException(ErrorInfo e) {
            return new UserDoesNotExistException(e);
        }
    }
    ,
    INVALID_USERNAME{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("INVALID_USERNAME", String.format("The supplied username %s is not valid!", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public InvalidUsernameException getException(ErrorInfo e) {
            return new InvalidUsernameException(e);
        }
    }
    ,
    INVALID_PASSWORD{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("INVALID_PASSWORD", String.format("The supplied password %s is not valid!", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public InvalidPasswordException getException(ErrorInfo e) {
            return new InvalidPasswordException(e);
        }
    };


    public abstract ErrorInfo getErrorInfo(String ... var1);

    public abstract Response.Status getHttpCode();

    public abstract <T extends GenericException> T getException(ErrorInfo var1);
}

