/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication.repository;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.model.User;
import eu.europeana.cloud.service.aas.authentication.SpringUser;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.status.IdentifierErrorTemplate;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Retryable
public class CassandraUserDAO {
    private static final Log LOGGER = LogFactory.getLog(CassandraUserDAO.class);
    private static final Set<String> DEFAULT_USER_ROLES = Set.of("ROLE_USER");
    @Qualifier(value="dbService")
    private final CassandraConnectionProvider provider;
    private PreparedStatement selectUserStatement;
    private PreparedStatement createUserStatement;
    private PreparedStatement updateUserStatement;
    private PreparedStatement blockageUserStatement;

    public CassandraUserDAO(CassandraConnectionProvider provider) {
        LOGGER.info((Object)"CassandraUserDAO starting...");
        this.provider = provider;
        this.prepareStatements();
        LOGGER.info((Object)"CassandraUserDAO started successfully.");
    }

    private void prepareStatements() {
        this.selectUserStatement = this.provider.getSession().prepare("SELECT * FROM users WHERE username = ?");
        this.createUserStatement = this.provider.getSession().prepare("INSERT INTO users(username, password, roles,locked) VALUES (?,?,?,?) IF NOT EXISTS;");
        this.updateUserStatement = this.provider.getSession().prepare("UPDATE users SET password = ? WHERE username = ?;");
        this.blockageUserStatement = this.provider.getSession().prepare("UPDATE users SET locked = ? WHERE username = ?;");
    }

    public SpringUser getUser(String username) throws DatabaseConnectionException {
        try {
            BoundStatement boundStatement = this.selectUserStatement.bind(new Object[]{username});
            ResultSet rs = this.provider.getSession().execute((Statement)boundStatement);
            Row result = rs.one();
            if (result == null) {
                return null;
            }
            return this.mapUser(result);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void createUser(User user) throws DatabaseConnectionException {
        try {
            BoundStatement boundStatement = this.createUserStatement.bind(new Object[]{user.getUsername(), user.getPassword(), DEFAULT_USER_ROLES, user.isLocked()});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void updateUser(User user) throws DatabaseConnectionException {
        try {
            BoundStatement boundStatement = this.updateUserStatement.bind(new Object[]{user.getPassword(), user.getUsername()});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void lockUser(String userName) throws DatabaseConnectionException {
        try {
            BoundStatement boundStatement = this.blockageUserStatement.bind(new Object[]{Boolean.TRUE, userName});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void unlockUser(String userName) throws DatabaseConnectionException {
        try {
            BoundStatement boundStatement = this.blockageUserStatement.bind(new Object[]{Boolean.FALSE, userName});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    private SpringUser mapUser(Row row) {
        String username = row.getString("username");
        String password = row.getString("password");
        Set roles = row.getSet("roles", String.class);
        boolean locked = row.getBool("locked");
        return new SpringUser(username, password, roles, locked);
    }
}

