/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication.handlers;

import eu.europeana.cloud.common.response.ErrorInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class CloudAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        response.setStatus(401);
        response.setHeader("Content-Type", "application/xml");
        this.writeErrorInfo(response.getWriter(), (Exception)authException);
    }

    private void writeErrorInfo(PrintWriter writer, Exception exception) {
        try {
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{ErrorInfo.class});
            Marshaller marshallerObj = contextObj.createMarshaller();
            marshallerObj.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ErrorInfo e = new ErrorInfo("ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION", exception.getMessage());
            marshallerObj.marshal((Object)e, (Writer)writer);
        }
        catch (JAXBException e) {
            writer.println("<errorInfo><errorCode>OTHER</errorCode><details>" + e.getMessage() + "</details></errorInfo>");
        }
    }
}

