/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication;

import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.model.User;
import eu.europeana.cloud.service.aas.authentication.AuthenticationService;
import eu.europeana.cloud.service.aas.authentication.SpringUser;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import eu.europeana.cloud.service.aas.authentication.repository.CassandraUserDAO;
import eu.europeana.cloud.service.aas.authentication.status.IdentifierErrorTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CassandraAuthenticationService
implements UserDetailsService,
AuthenticationService {
    @Autowired
    private CassandraUserDAO userDao;

    public CassandraAuthenticationService() {
    }

    public CassandraAuthenticationService(CassandraUserDAO userDao) {
        this.userDao = userDao;
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        try {
            SpringUser user = this.userDao.getUser(userName);
            if (user == null) {
                throw new UsernameNotFoundException("Username '" + userName + "' could not be retrieved from the database!");
            }
            return this.userDao.getUser(userName);
        }
        catch (DatabaseConnectionException ex) {
            throw new UsernameNotFoundException("Username '" + userName + "' could not be retrieved due to database error!", (Throwable)((Object)ex));
        }
    }

    @Override
    public User getUser(String userName) throws DatabaseConnectionException, UserDoesNotExistException {
        SpringUser user = this.userDao.getUser(userName);
        if (user == null) {
            throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getErrorInfo(userName)));
        }
        return this.userDao.getUser(userName);
    }

    @Override
    public void lockUser(String userName) throws DatabaseConnectionException, UserDoesNotExistException {
        if (this.userDao.getUser(userName) == null) {
            throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_EXISTS.getHttpCode(), IdentifierErrorTemplate.USER_EXISTS.getErrorInfo(userName)));
        }
        this.userDao.lockUser(userName);
    }

    @Override
    public void unlockUser(String userName) throws DatabaseConnectionException, UserDoesNotExistException {
        if (this.userDao.getUser(userName) == null) {
            throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_EXISTS.getHttpCode(), IdentifierErrorTemplate.USER_EXISTS.getErrorInfo(userName)));
        }
        this.userDao.unlockUser(userName);
    }

    @Override
    public void createUser(User user) throws DatabaseConnectionException, UserExistsException {
        if (this.userDao.getUser(user.getUsername()) != null) {
            throw new UserExistsException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_EXISTS.getHttpCode(), IdentifierErrorTemplate.USER_EXISTS.getErrorInfo(user.getUsername())));
        }
        this.userDao.createUser(user);
    }

    @Override
    public void updateUser(User user) throws DatabaseConnectionException, UserDoesNotExistException {
        if (this.userDao.getUser(user.getUsername()) == null) {
            throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getErrorInfo(user.getUsername())));
        }
        this.userDao.updateUser(user);
    }
}

