/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication;

import eu.europeana.cloud.common.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SpringUser
extends User
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private List<GrantedAuthority> roles = new ArrayList<GrantedAuthority>(0);

    public SpringUser(String username, String password, Set<String> userRoles) {
        super(username, password);
        this.roles = this.mapToStringRoles(userRoles);
    }

    public SpringUser(String username, String password) {
        super(username, password);
    }

    private List<GrantedAuthority> mapToStringRoles(Set<String> userRoles) {
        HashSet<SimpleGrantedAuthority> setAuths = new HashSet<SimpleGrantedAuthority>();
        for (String userRole : userRoles) {
            setAuths.add(new SimpleGrantedAuthority(userRole));
        }
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>(setAuths);
        return result;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.roles;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

