/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication;

import eu.europeana.cloud.common.model.User;
import eu.europeana.cloud.service.aas.authentication.AuthenticationService;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidPasswordException;
import eu.europeana.cloud.service.aas.authentication.exception.InvalidUsernameException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import eu.europeana.cloud.service.aas.authentication.repository.CassandraUserDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CassandraAuthenticationService
implements UserDetailsService,
AuthenticationService {
    @Autowired
    private CassandraUserDAO userDao;

    public CassandraAuthenticationService() {
    }

    public CassandraAuthenticationService(CassandraUserDAO userDao) {
        this.userDao = userDao;
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        try {
            return this.userDao.getUser(userName);
        }
        catch (DatabaseConnectionException ex) {
            throw new UsernameNotFoundException("Username '" + userName + "' could not be retrieved due to database error!", (Throwable)((Object)ex));
        }
        catch (UserDoesNotExistException ex) {
            throw new UsernameNotFoundException("Username '" + userName + "' could not be retrieved from the database!", (Throwable)((Object)ex));
        }
    }

    @Override
    public User getUser(String userName) throws DatabaseConnectionException, UserDoesNotExistException {
        return this.userDao.getUser(userName);
    }

    @Override
    public void createUser(User user) throws DatabaseConnectionException, UserExistsException, InvalidUsernameException, InvalidPasswordException {
        this.userDao.createUser(user);
    }

    @Override
    public void updateUser(User user) throws DatabaseConnectionException, UserDoesNotExistException, InvalidPasswordException {
        this.userDao.updateUser(user);
    }

    @Override
    public void deleteUser(String userName) throws DatabaseConnectionException, UserDoesNotExistException {
        this.userDao.deleteUser(userName);
    }
}

