/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.aas.authentication.repository;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.collect.ImmutableSet;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.model.User;
import eu.europeana.cloud.service.aas.authentication.SpringUser;
import eu.europeana.cloud.service.aas.authentication.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.aas.authentication.exception.UserDoesNotExistException;
import eu.europeana.cloud.service.aas.authentication.exception.UserExistsException;
import eu.europeana.cloud.service.aas.authentication.status.IdentifierErrorTemplate;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class CassandraUserDAO {
    private static final Log LOGGER = LogFactory.getLog(CassandraUserDAO.class);
    @Qualifier(value="dbService")
    private CassandraConnectionProvider provider;
    private PreparedStatement selectUserStatement;
    private PreparedStatement createUserStatement;
    private PreparedStatement updateUserStatement;
    private PreparedStatement deleteUserStatement;
    private static Set<String> DEFAULT_USER_ROLES = ImmutableSet.of((Object)"ROLE_USER");

    public CassandraUserDAO(CassandraConnectionProvider provider) {
        LOGGER.info((Object)"CassandraUserDAO starting...");
        this.provider = provider;
        this.prepareStatements();
        LOGGER.info((Object)"CassandraUserDAO started successfully.");
    }

    private void prepareStatements() {
        this.selectUserStatement = this.provider.getSession().prepare("SELECT * FROM users WHERE username = ?");
        this.selectUserStatement.setConsistencyLevel(this.provider.getConsistencyLevel());
        this.createUserStatement = this.provider.getSession().prepare("INSERT INTO users(username, password, roles) VALUES (?,?,?) IF NOT EXISTS;");
        this.createUserStatement.setConsistencyLevel(this.provider.getConsistencyLevel());
        this.updateUserStatement = this.provider.getSession().prepare("UPDATE users SET password = ? WHERE username = ?;");
        this.updateUserStatement.setConsistencyLevel(this.provider.getConsistencyLevel());
        this.deleteUserStatement = this.provider.getSession().prepare("DELETE FROM users WHERE username = ?;");
        this.deleteUserStatement.setConsistencyLevel(this.provider.getConsistencyLevel());
    }

    public SpringUser getUser(String username) throws DatabaseConnectionException, UserDoesNotExistException {
        try {
            BoundStatement boundStatement = this.selectUserStatement.bind(new Object[]{username});
            ResultSet rs = this.provider.getSession().execute((Statement)boundStatement);
            Row result = rs.one();
            if (result == null) {
                throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getErrorInfo(username)));
            }
            return this.mapUser(result);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void createUser(User user) throws DatabaseConnectionException, UserExistsException {
        try {
            if (this.userAlreadyExistsInDB(user.getUsername())) {
                throw new UserExistsException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_EXISTS.getHttpCode(), IdentifierErrorTemplate.USER_EXISTS.getErrorInfo(user.getUsername())));
            }
            BoundStatement boundStatement = this.createUserStatement.bind(new Object[]{user.getUsername(), user.getPassword(), null});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void updateUser(User user) throws DatabaseConnectionException, UserDoesNotExistException {
        BoundStatement boundStatement;
        try {
            boundStatement = this.selectUserStatement.bind(new Object[]{user.getUsername()});
            ResultSet rs = this.provider.getSession().execute((Statement)boundStatement);
            Row result = rs.one();
            if (result == null) {
                throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getErrorInfo(user.getUsername())));
            }
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
        try {
            boundStatement = this.updateUserStatement.bind(new Object[]{user.getUsername(), user.getPassword()});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    public void deleteUser(String username) throws DatabaseConnectionException, UserDoesNotExistException {
        BoundStatement boundStatement;
        try {
            boundStatement = this.selectUserStatement.bind(new Object[]{username});
            ResultSet rs = this.provider.getSession().execute((Statement)boundStatement);
            Row result = rs.one();
            if (result == null) {
                throw new UserDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.USER_DOES_NOT_EXIST.getErrorInfo(username)));
            }
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
        try {
            boundStatement = this.deleteUserStatement.bind(new Object[]{username});
            this.provider.getSession().execute((Statement)boundStatement);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.provider.getHosts(), this.provider.getPort(), e.getMessage())));
        }
    }

    private SpringUser mapUser(Row row) {
        String username = row.getString("username");
        String password = row.getString("password");
        Set roles = row.getSet("roles", String.class);
        SpringUser user = new SpringUser(username, password, roles);
        return user;
    }

    private boolean userAlreadyExistsInDB(String userName) {
        BoundStatement boundStatement = this.selectUserStatement.bind(new Object[]{userName});
        ResultSet rs = this.provider.getSession().execute((Statement)boundStatement);
        Row result = rs.one();
        return result != null;
    }
}

