/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.ReflectionUtils;

public class OracleTableMetaDataProvider
extends GenericTableMetaDataProvider {
    private final boolean includeSynonyms;

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData, false);
    }

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData, boolean includeSynonyms) throws SQLException {
        super(databaseMetaData);
        this.includeSynonyms = includeSynonyms;
    }

    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        Method setIncludeSynonyms;
        Boolean originalValueForIncludeSynonyms;
        boolean isOracleCon;
        if (!this.includeSynonyms) {
            logger.debug((Object)"Defaulting to no synonyms in table metadata lookup");
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        Connection con = databaseMetaData.getConnection();
        NativeJdbcExtractor nativeJdbcExtractor = this.getNativeJdbcExtractor();
        if (nativeJdbcExtractor != null) {
            con = nativeJdbcExtractor.getNativeConnection(con);
        }
        try {
            Class<?> oracleConClass = this.getClass().getClassLoader().loadClass("oracle.jdbc.OracleConnection");
            isOracleCon = oracleConClass.isInstance(con);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Couldn't find Oracle JDBC API: " + ex));
            }
            isOracleCon = false;
        }
        if (!isOracleCon) {
            logger.warn((Object)("Unable to include synonyms in table metadata lookup. Connection used for DatabaseMetaData is not recognized as an Oracle connection: " + con));
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        logger.debug((Object)"Including synonyms in table metadata lookup");
        try {
            Method getIncludeSynonyms = con.getClass().getMethod("getIncludeSynonyms", null);
            ReflectionUtils.makeAccessible(getIncludeSynonyms);
            originalValueForIncludeSynonyms = (Boolean)getIncludeSynonyms.invoke((Object)con, new Object[0]);
            setIncludeSynonyms = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
            ReflectionUtils.makeAccessible(setIncludeSynonyms);
            setIncludeSynonyms.invoke((Object)con, Boolean.TRUE);
        }
        catch (Exception ex) {
            throw new InvalidDataAccessApiUsageException("Couldn't prepare Oracle Connection", ex);
        }
        super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
        try {
            setIncludeSynonyms.invoke((Object)con, originalValueForIncludeSynonyms);
        }
        catch (Exception ex) {
            throw new InvalidDataAccessApiUsageException("Couldn't reset Oracle Connection", ex);
        }
    }
}

