/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.jobs;

import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.data.RevisionInformation;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class RevisionRemoverJob
implements Runnable {
    static final Logger LOGGER = Logger.getLogger(RevisionRemoverJob.class);
    private DataSetServiceClient dataSetServiceClient;
    private RecordServiceClient recordServiceClient;
    private RevisionServiceClient revisionServiceClient;
    private RevisionInformation revisionInformation;
    private static final int SLEEP_TIME = 600000;

    public RevisionRemoverJob(DataSetServiceClient dataSetServiceClient, RecordServiceClient recordServiceClient, RevisionInformation revisionInformation, RevisionServiceClient revisionServiceClient) {
        this.dataSetServiceClient = dataSetServiceClient;
        this.recordServiceClient = recordServiceClient;
        this.revisionServiceClient = revisionServiceClient;
        this.revisionInformation = revisionInformation;
    }

    @Override
    public void run() {
        try {
            int batchNumber = 1;
            String startFrom = null;
            do {
                ResultSlice resultSlice;
                if ((resultSlice = this.dataSetServiceClient.getDataSetRevisionsChunk(this.revisionInformation.getProviderId(), this.revisionInformation.getDataSet(), this.revisionInformation.getRepresentationName(), this.revisionInformation.getRevisionName(), this.revisionInformation.getRevisionProvider(), this.revisionInformation.getRevisionTimeStamp(), startFrom, null)) == null || resultSlice.getResults() == null) {
                    throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
                }
                List cloudTagsResponses = resultSlice.getResults();
                block3: for (CloudTagsResponse cloudTagsResponse : cloudTagsResponses) {
                    List representations = this.recordServiceClient.getRepresentationsByRevision(cloudTagsResponse.getCloudId(), this.revisionInformation.getRepresentationName(), this.revisionInformation.getRevisionName(), this.revisionInformation.getRevisionProvider(), this.revisionInformation.getRevisionTimeStamp());
                    for (Representation representation : representations) {
                        if (representation.getRevisions().size() == 1) {
                            this.removeRepresentationWithFilesAndRevisions(cloudTagsResponse, representation);
                            continue block3;
                        }
                        this.removeRevisionsOnly(representation);
                    }
                }
                startFrom = resultSlice.getNextSlice();
                LOGGER.info((Object)("The removal of revision " + this.revisionInformation.getRevisionName() + "_" + this.revisionInformation.getRevisionProvider() + "_" + this.revisionInformation.getRevisionTimeStamp() + " inside dataset: " + this.revisionInformation.getDataSet() + "_" + this.revisionInformation.getProviderId() + " is in progress!. This is the batch number: " + batchNumber));
                ++batchNumber;
            } while (startFrom != null);
            LOGGER.info((Object)("The removal of revision " + this.revisionInformation.getRevisionName() + "_" + this.revisionInformation.getRevisionProvider() + "_" + this.revisionInformation.getRevisionTimeStamp() + " inside dataset: " + this.revisionInformation.getDataSet() + "_" + this.revisionInformation.getProviderId() + " was a success!"));
            LOGGER.info((Object)"***********************");
        }
        catch (Exception e) {
            LOGGER.error((Object)("The removal of revision " + this.revisionInformation.getRevisionName() + "_" + this.revisionInformation.getRevisionProvider() + "_" + this.revisionInformation.getRevisionTimeStamp() + " inside dataset: " + this.revisionInformation.getDataSet() + "_" + this.revisionInformation.getProviderId() + " was a failure. Please remove it again"), (Throwable)e);
        }
    }

    private void removeRevisionsOnly(Representation representation) throws MCSException {
        DateTime utc = new DateTime((Object)this.revisionInformation.getRevisionTimeStamp(), DateTimeZone.UTC);
        Date revisionDate = utc.toDate();
        for (Revision revision : representation.getRevisions()) {
            if (!this.revisionInformation.getRevisionName().equals(revision.getRevisionName()) || !this.revisionInformation.getRevisionProvider().equals(revision.getRevisionProviderId()) || revisionDate.getTime() != revision.getCreationTimeStamp().getTime()) continue;
            this.removeSpecificRevision(representation);
        }
    }

    private void removeSpecificRevision(Representation representation) throws MCSException {
        int retries = 2;
        while (true) {
            try {
                this.revisionServiceClient.deleteRevision(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), this.revisionInformation.getRevisionName(), this.revisionInformation.getRevisionProvider(), this.revisionInformation.getRevisionTimeStamp());
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error while removing the revision." + this.revisionInformation.getRevisionName() + "_" + this.revisionInformation.getRevisionProvider() + "_" + this.revisionInformation.getRevisionTimeStamp() + ". Will retry after 10 minutes. Retries left: " + --retries));
                this.waitForTheNextCall();
                if (retries > 0) continue;
                throw e;
            }
            break;
        }
    }

    private void removeRepresentationWithFilesAndRevisions(CloudTagsResponse cloudTagsResponse, Representation representation) throws MCSException {
        int retries = 2;
        while (true) {
            try {
                this.recordServiceClient.deleteRepresentation(cloudTagsResponse.getCloudId(), representation.getRepresentationName(), representation.getVersion());
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error while removing the presentation Version. will retry after 10 minutes. Retries left: " + --retries));
                this.waitForTheNextCall();
                if (retries > 0) continue;
                throw e;
            }
            break;
        }
    }

    void setRevisionInformation(RevisionInformation revisionInformation) {
        this.revisionInformation = revisionInformation;
    }

    private void waitForTheNextCall() {
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            LOGGER.error((Object)e1.getMessage());
        }
    }
}

