/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.integration;

import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.jsonp.JsonProcessingFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;

public class UisPerformanceTests {
    public static void main(String[] args) {
        Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JettisonFeature.class)).register(JacksonFeature.class)).register(MoxyJsonFeature.class)).register(MultiPartFeature.class)).register(JsonProcessingFeature.class)).build();
        String baseUrl = "http://store2.tel.private/";
        String UIS_PREFIX = "ecloud-service-uis-rest";
        long startTime = System.nanoTime();
        DataProviderProperties dp = new DataProviderProperties("TEL", "", "", "", "", "", "Ingesion Tool Provider", "");
        Response resp = client.target(baseUrl + UIS_PREFIX + "/data-providers").queryParam("providerId", new Object[]{"TEL"}).request().post(Entity.json((Object)dp));
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            System.out.println("Provider 'TEL' has been created!");
        } else {
            System.out.println("Provider 'TEL' exists!");
        }
        System.out.println("Provider setup: '" + (System.nanoTime() - startTime) / 1000000L + "' msec");
        long getCloudIdTime = 0L;
        long createCloudIdTime = 0L;
        for (int i = 0; i < 100000; ++i) {
            CloudId cloudId;
            long recordId = System.nanoTime();
            long localTime = System.nanoTime();
            resp = client.target(baseUrl + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{"TEL"}).queryParam("recordId", new Object[]{recordId}).request().get();
            getCloudIdTime += System.nanoTime() - localTime;
            if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
                cloudId = (CloudId)resp.readEntity(CloudId.class);
            } else {
                localTime = System.nanoTime();
                resp = client.target(baseUrl + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{"TEL"}).queryParam("recordId", new Object[]{recordId}).request().post(null);
                createCloudIdTime += System.nanoTime() - localTime;
                if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
                    cloudId = (CloudId)resp.readEntity(CloudId.class);
                } else {
                    System.out.println("Could not create cloud id for '" + recordId + "'! " + resp.getStatusInfo() + " " + resp.getStatusInfo().getReasonPhrase());
                    continue;
                }
            }
            if (i % 500 != 0) continue;
            System.out.println("Time overall: '" + (System.nanoTime() - startTime) / 1000000000L + "' sec");
            System.out.println("Time get cloudId: '" + getCloudIdTime / 1000000000L + "' sec");
            System.out.println("Time create cloudId: '" + createCloudIdTime / 1000000000L + "' sec");
        }
        System.out.println("Time overall: '" + (System.nanoTime() - startTime) / 1000000000L + "' sec");
        System.out.println("Time get cloudId: '" + getCloudIdTime / 1000000000L + "' sec");
        System.out.println("Time create cloudId: '" + createCloudIdTime / 1000000000L + "' sec");
    }
}

