/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.integration;

import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.UniqueIdentifierService;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceUISClientHandler
implements UISClientHandler {
    @Autowired
    private DataProviderService dataProviderService;
    @Autowired
    private UniqueIdentifierService uniqueIdentifierService;

    public boolean existsCloudId(String cloudId) {
        boolean exists = false;
        try {
            List ids = this.uniqueIdentifierService.getLocalIdsByCloudId(cloudId);
            exists = ids != null && !ids.isEmpty();
        }
        catch (ProviderDoesNotExistException | CloudIdDoesNotExistException | DatabaseConnectionException | RecordDatasetEmptyException throwable) {
            // empty catch block
        }
        return exists;
    }

    public CloudId getCloudIdFromProviderAndLocalId(String providerId, String localId) throws ProviderNotExistsException, RecordNotExistsException {
        CloudId cloudId = null;
        try {
            return this.uniqueIdentifierService.getCloudId(providerId, localId);
        }
        catch (ProviderDoesNotExistException | DatabaseConnectionException | RecordDatasetEmptyException | RecordDoesNotExistException e) {
            return cloudId;
        }
    }

    public DataProvider getProvider(String providerId) {
        DataProvider result = null;
        try {
            result = this.dataProviderService.getProvider(providerId);
        }
        catch (ProviderDoesNotExistException providerDoesNotExistException) {
            // empty catch block
        }
        return result;
    }

    public boolean existsProvider(String providerId) {
        DataProvider result = null;
        try {
            result = this.dataProviderService.getProvider(providerId);
        }
        catch (ProviderDoesNotExistException providerDoesNotExistException) {
            // empty catch block
        }
        return result != null;
    }
}

