/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.integration;

import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.UniqueIdentifierService;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ServiceIngestionTool {
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private RecordService recordService;
    @Autowired
    private DataProviderService dataProviderService;
    @Autowired
    private UniqueIdentifierService uniqueIdentifierService;
    @Option(name="-o", aliases={"--operation"}, required=true)
    private Operation operation;
    @Option(name="-p", aliases={"--provider"}, usage="Provider for which a dataset should be ingested")
    private String providerId;
    @Option(name="-d", aliases={"--dataset"}, usage="Dataset for which the data should be ingested")
    private String dataSetId;
    @Option(name="-s", aliases={"--schema"}, usage="Schema specifying the format of the dataset!")
    private String schema;
    @Option(name="-f", aliases={"--file"}, metaVar="DIR", usage="Directory with files to be ingested!")
    private String directory;

    private void run() {
        switch (this.operation) {
            case ingestDataSet: {
                try {
                    this.ingestDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not ingest dataset!", e);
                }
            }
            case readDataSet: {
                try {
                    this.readDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read dataset!", e);
                }
            }
            case deleteDataSet: {
                try {
                    this.deleteDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not delete dataset!", e);
                }
            }
        }
    }

    private void ingestDataSet() throws Exception {
        try {
            this.dataProviderService.createProvider(this.providerId, new DataProviderProperties(this.providerId, "", "", "", "", "", "Ingestion Tool Provide4", ""));
        }
        catch (ProviderAlreadyExistsException e) {
            // empty catch block
        }
        try {
            this.dataSetService.createDataSet(this.providerId, this.dataSetId, "Ingestion Tool Dataset");
        }
        catch (ProviderNotExistsException e) {
            throw e;
        }
        catch (DataSetAlreadyExistsException e) {
            // empty catch block
        }
        Iterator iter = FileUtils.iterateFiles((File)new File(this.directory), null, (boolean)true);
        while (iter.hasNext()) {
            File input = (File)iter.next();
            FileInputStream is = new FileInputStream(input);
            Throwable throwable = null;
            try {
                eu.europeana.cloud.common.model.File file = new eu.europeana.cloud.common.model.File();
                file.setFileName(input.getName());
                file.setMimeType("text");
                CloudId cloudId = this.uniqueIdentifierService.createCloudId(new String[]{this.providerId, input.getName()});
                Representation represantation = this.recordService.createRepresentation(cloudId.getId(), this.schema, this.providerId);
                this.recordService.putContent(cloudId.getId(), represantation.getRepresentationName(), represantation.getVersion(), file, (InputStream)is);
                this.recordService.persistRepresentation(cloudId.getId(), this.schema, represantation.getVersion());
                this.dataSetService.addAssignment(this.providerId, this.dataSetId, represantation.getCloudId(), represantation.getRepresentationName(), represantation.getVersion());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private void readDataSet() throws Exception {
        ResultSlice dataset = this.dataSetService.listDataSet(this.providerId, this.dataSetId, null, Integer.MAX_VALUE);
        for (Representation representation : dataset.getResults()) {
            FileOutputStream os = new FileOutputStream(new File(this.directory + "/" + ((eu.europeana.cloud.common.model.File)representation.getFiles().get(0)).getFileName()));
            Throwable throwable = null;
            try {
                this.recordService.getContent(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), ((eu.europeana.cloud.common.model.File)representation.getFiles().get(0)).getFileName(), (OutputStream)os);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                os.close();
            }
        }
    }

    private void deleteDataSet() throws Exception {
        ResultSlice dataset = this.dataSetService.listDataSet(this.providerId, this.dataSetId, null, Integer.MAX_VALUE);
        for (Representation representation : dataset.getResults()) {
            this.recordService.deleteRepresentation(representation.getCloudId(), representation.getRepresentationName());
            this.dataSetService.removeAssignment(this.providerId, this.dataSetId, representation.getCloudId(), representation.getRepresentationName());
        }
        this.dataSetService.deleteDataSet(this.providerId, this.dataSetId);
    }

    public static void main(String[] args) {
        try (ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("inmemoryIngestionToolContext.xml");){
            ServiceIngestionTool tool = (ServiceIngestionTool)context.getBean(ServiceIngestionTool.class);
            CmdLineParser parser = new CmdLineParser((Object)tool);
            try {
                parser.parseArgument(args);
                tool.run();
            }
            catch (CmdLineException e) {
                System.err.println(e.getMessage());
                parser.printUsage((OutputStream)System.err);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    public static enum Operation {
        ingestDataSet("Ingests a data set for a given provider-id, dataset-id, schema and directory!"),
        readDataSet("Reads a data set for a given provider-id, dataset-id, schema and directory!"),
        deleteDataSet("Deletes a data set for a given provider-id, dataset-id, schema and directory!");

        private final String description;

        private Operation(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

