/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.integration;

import com.google.common.io.ByteStreams;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.jsonp.JsonProcessingFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.springframework.stereotype.Component;

@Component
public class RestIngestionTool {
    @Option(name="-o", aliases={"--operation"}, required=true)
    private Operation operation;
    @Option(name="-p", aliases={"--provider"}, usage="Provider for which a dataset should be ingested")
    private String providerId;
    @Option(name="-d", aliases={"--dataset"}, usage="Dataset for which the data should be ingested")
    private String dataSetId;
    @Option(name="-s", aliases={"--schema"}, usage="Schema specifying the format of the dataset!")
    private String schema;
    @Option(name="-f", aliases={"--file"}, metaVar="DIR", usage="Directory with files to be ingested!")
    private String directory;
    private Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JettisonFeature.class)).register(JacksonFeature.class)).register(MoxyJsonFeature.class)).register(MultiPartFeature.class)).register(JsonProcessingFeature.class)).build();
    private String baseUrl = "http://ecloud.eanadev.org:8080/";
    private static final String UIS_PREFIX = "ecloud-service-uis-rest-0.1-SNAPSHOT";
    private static final String MCS_PREFIX = "ecloud-service-mcs-rest-0.1-SNAPSHOT";

    private void run() {
        switch (this.operation) {
            case ingestDataSet: {
                try {
                    this.ingestDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not ingest dataset!", e);
                }
            }
            case readDataSet: {
                try {
                    this.readDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read dataset!", e);
                }
            }
            case deleteDataSet: {
                try {
                    this.deleteDataSet();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not delete dataset!", e);
                }
            }
        }
    }

    private void ingestDataSet() throws Exception {
        long startTime = System.nanoTime();
        DataProviderProperties dp = new DataProviderProperties(this.providerId, "", "", "", "", "", "Ingesion Tool Provider", "");
        Response resp = this.client.target(this.baseUrl + UIS_PREFIX + "/data-providers").queryParam("providerId", new Object[]{this.providerId}).request().post(Entity.json((Object)dp));
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            System.out.println("Provider '" + this.providerId + "' has been created!");
        } else {
            System.out.println("Provider '" + this.providerId + "' exists!");
        }
        System.out.println("Provider setup: '" + (System.nanoTime() - startTime) / 1000000L + "' msec");
        startTime = System.nanoTime();
        resp = this.client.target(this.baseUrl + MCS_PREFIX + "/data-providers/" + this.providerId + "/data-sets").request().post(Entity.form((Form)new Form("dataSetId", this.dataSetId).param("description", "Ingestion Tool Dataset")));
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            System.out.println("Dataset '" + this.dataSetId + "' has been created!");
        } else {
            System.out.println("Dataset '" + this.dataSetId + "' exists!");
        }
        System.out.println("Dataset setup: '" + (System.nanoTime() - startTime) / 1000000L + "' msec");
        startTime = System.nanoTime();
        long cloudIdTime = 0L;
        long representationTime = 0L;
        long uploadTime = 0L;
        long persistTime = 0L;
        long assignTime = 0L;
        int scheduled = 0;
        int done = 0;
        Iterator iter = FileUtils.iterateFiles((File)new File(this.directory), null, (boolean)true);
        while (iter.hasNext()) {
            CloudId cloudId;
            ++scheduled;
            File input = (File)iter.next();
            eu.europeana.cloud.common.model.File file = new eu.europeana.cloud.common.model.File();
            file.setFileName(input.getName());
            file.setMimeType("text");
            long localTime = System.nanoTime();
            int endIdx = input.getName().lastIndexOf(".");
            String localId = endIdx > 0 ? input.getName().substring(0, endIdx) : input.getName();
            resp = this.client.target(this.baseUrl + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{this.providerId}).queryParam("recordId", new Object[]{localId}).request().get();
            if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
                cloudId = (CloudId)resp.readEntity(CloudId.class);
            } else {
                resp = this.client.target(this.baseUrl + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{this.providerId}).queryParam("recordId", new Object[]{localId}).request().post(null);
                if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
                    cloudId = (CloudId)resp.readEntity(CloudId.class);
                } else {
                    System.out.println("Could not create cloud id for '" + localId + "'!");
                    continue;
                }
            }
            cloudIdTime += System.nanoTime() - localTime;
            localTime = System.nanoTime();
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/records/" + cloudId.getId() + "/representations/" + this.schema).request().post(Entity.entity((Object)new Form("providerId", this.providerId), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (resp.getStatus() == Response.Status.CREATED.getStatusCode()) {
                if ((resp = this.client.target(resp.getLocation()).request().get()).getStatus() != Response.Status.OK.getStatusCode()) {
                    System.out.println("Could not retrieve newly created representation for '" + cloudId.getId() + "'!");
                    continue;
                }
            } else {
                System.out.println("Could not create representation for '" + cloudId.getId() + "'!");
                continue;
            }
            Representation representation = (Representation)resp.readEntity(Representation.class);
            representationTime += System.nanoTime() - localTime;
            localTime = System.nanoTime();
            byte[] content = FileUtils.readFileToByteArray((File)input);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", file.getMimeType()).field("data", (Object)new ByteArrayInputStream(content), MediaType.APPLICATION_OCTET_STREAM_TYPE);
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName() + "/versions/" + representation.getVersion() + "/files/" + file.getFileName()).request().put(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
            if (resp.getStatus() != Response.Status.CREATED.getStatusCode()) {
                System.out.println("Could not upload file for '" + cloudId.getId() + "'!");
                continue;
            }
            uploadTime += System.nanoTime() - localTime;
            localTime = System.nanoTime();
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName() + "/versions/" + representation.getVersion() + "/persist").request().post(null);
            if (resp.getStatus() != Response.Status.CREATED.getStatusCode()) {
                System.out.println("Could not persist representation for '" + cloudId.getId() + "'!");
                continue;
            }
            persistTime += System.nanoTime() - localTime;
            localTime = System.nanoTime();
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/data-providers/" + this.providerId + "/data-sets/" + this.dataSetId + "/assignments").request().post(Entity.form((Form)new Form("recordId", representation.getCloudId()).param("schema", representation.getRepresentationName())));
            if (resp.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                System.out.println("Could not assign representation for '" + cloudId.getId() + "'!");
                continue;
            }
            assignTime += System.nanoTime() - localTime;
            ++done;
            if (scheduled % 10 != 0) continue;
            System.out.println("Scheduled: " + scheduled);
            System.out.println("Done: " + done);
            System.out.println("Time overall: '" + (System.nanoTime() - startTime) / 1000000000L + "' sec");
            System.out.println("Time cloudId: '" + cloudIdTime / 1000000000L + "' sec");
            System.out.println("Time representation: '" + representationTime / 1000000000L + "' sec");
            System.out.println("Time upload: '" + uploadTime / 1000000000L + "' sec");
            System.out.println("Time persist: '" + persistTime / 1000000000L + "' sec");
            System.out.println("Time assign: '" + assignTime / 1000000000L + "' sec");
        }
        System.out.println("Scheduled: " + scheduled);
        System.out.println("Done: " + done);
    }

    private void readDataSet() throws Exception {
        Response resp = this.client.target(this.baseUrl + MCS_PREFIX + "/data-providers/" + this.providerId + "/data-sets/" + this.dataSetId).request().get();
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            return;
        }
        ResultSlice dataset = (ResultSlice)resp.readEntity(ResultSlice.class);
        int scheduled = 0;
        int done = 0;
        for (Representation representation : dataset.getResults()) {
            ++scheduled;
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName() + "/versions/" + representation.getVersion() + "/files/" + ((eu.europeana.cloud.common.model.File)representation.getFiles().get(0)).getFileName()).request().get();
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) continue;
            InputStream responseStream = (InputStream)resp.readEntity(InputStream.class);
            byte[] responseContent = ByteStreams.toByteArray((InputStream)responseStream);
            FileUtils.writeByteArrayToFile((File)new File(this.directory + "/" + ((eu.europeana.cloud.common.model.File)representation.getFiles().get(0)).getFileName()), (byte[])responseContent);
            ++done;
            if (scheduled % 100 != 0) continue;
            System.out.println("Scheduled: " + scheduled);
            System.out.println("Done: " + done);
        }
        System.out.println("Scheduled: " + scheduled);
        System.out.println("Done: " + done);
    }

    private void deleteDataSet() throws Exception {
        Response resp = this.client.target(this.baseUrl + MCS_PREFIX + "/data-providers/" + this.providerId + "/data-sets/" + this.dataSetId).request().get();
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            System.out.println("Could not read dataset '" + this.dataSetId + "'!");
            return;
        }
        ResultSlice dataset = (ResultSlice)resp.readEntity(ResultSlice.class);
        int scheduled = 0;
        int done = 0;
        for (Representation representation : dataset.getResults()) {
            ++scheduled;
            resp = this.client.target(this.baseUrl + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName()).request().delete();
            if (resp.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                System.out.println("Could not delete representation for '" + representation.getCloudId() + "'!");
                continue;
            }
            ++done;
            if (scheduled % 100 != 0) continue;
            System.out.println("Scheduled: " + scheduled);
            System.out.println("Done: " + done);
        }
        System.out.println("Scheduled: " + scheduled);
        System.out.println("Done: " + done);
        resp = this.client.target(this.baseUrl + MCS_PREFIX + "/data-providers/" + this.providerId + "/data-sets/" + this.dataSetId).request().delete();
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            System.out.println("Could not delete dataset '" + this.dataSetId + "'!");
        }
        System.out.println("Deleted dataset: " + this.dataSetId);
    }

    public static void main(String[] args) {
        RestIngestionTool tool = new RestIngestionTool();
        CmdLineParser parser = new CmdLineParser((Object)tool);
        try {
            parser.parseArgument(args);
            tool.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static enum Operation {
        ingestDataSet("Ingests a data set for a given provider-id, dataset-id, schema and directory!"),
        readDataSet("Reads a data set for a given provider-id, dataset-id, schema and directory!"),
        deleteDataSet("Deletes a data set for a given provider-id, dataset-id, schema and directory!");

        private String description;

        private Operation(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

