/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.integration;

import com.google.gson.Gson;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.jsonp.JsonProcessingFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.springframework.util.StopWatch;

public class OUDatasetPerformanceTest {
    private static final String MCS_PREFIX = "mcs";
    private static final String UIS_PREFIX = "uis";
    private static Client client;
    @Option(name="-e", aliases={"--endpoint"}, usage="Endpoint of eCloud services")
    private static String SERVICES_ENDPOINT;
    @Option(name="-x", aliases={"--proxy"}, usage="Proxy to go through when accessing eCloud services", required=false)
    private static String HTTP_PROXY;
    @Option(name="-dpp", aliases={"--data-provider-properties"}, usage="Data provider properties as json", required=false)
    private static String dataProviderPropertiesJson;
    @Option(name="-p", aliases={"--provider", "--provider-id"}, usage="Provider for which a dataset should be ingested")
    private static String providerId;
    @Option(name="-d", aliases={"--dataset", "--dataset-id"}, usage="Ingested dataset id")
    private static String datasetId;
    @Option(name="-dd", aliases={"--dataset-description"}, usage="Ingested dataset description", required=false)
    private static String datasetDescription;
    @Option(name="-f", aliases={"--directory", "--folder"}, usage="Directory with the dataset to be ingested")
    private static String directory;

    public OUDatasetPerformanceTest() {
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.proxy.uri", (Object)HTTP_PROXY);
        cc.property("jersey.config.client.proxy.username", (Object)"");
        cc.property("jersey.config.client.proxy.password", (Object)"");
        client = ClientBuilder.newClient((Configuration)cc);
        client.register(JettisonFeature.class);
        client.register(JacksonFeature.class);
        client.register(MoxyJsonFeature.class);
        client.register(MultiPartFeature.class);
        client.register(JsonProcessingFeature.class);
    }

    public void ingest() {
        Gson gson = new Gson();
        DataProviderProperties dp = (DataProviderProperties)gson.fromJson(dataProviderPropertiesJson, DataProviderProperties.class);
        Response createProviderResp = this.createProvider(providerId, dp);
        if (createProviderResp.getStatus() == Response.Status.OK.getStatusCode()) {
            System.out.println("Provider '" + providerId + "' has been created!");
        } else {
            System.out.println("Provider '" + providerId + "' exists!");
        }
        Response createDatasetResp = this.createDataset(providerId, datasetId, datasetDescription);
        if (createDatasetResp.getStatus() == Response.Status.CREATED.getStatusCode()) {
            System.out.println("Dataset " + datasetId + " succesfully created.");
        } else {
            System.out.println("Could not create dataset " + datasetId + " ,response:" + createDatasetResp.toString());
        }
        Iterator directoryIterator = FileUtils.iterateFiles((File)new File(directory), null, (boolean)true);
        StopWatch taskWatch = new StopWatch(this.getClass().getSimpleName() + " seperate task watch");
        StopWatch recordWatch = new StopWatch(this.getClass().getSimpleName() + " record creation watch");
        long totalGetCloudidCounterMillis = 0L;
        long totalCreateRepresentationCounterMillis = 0L;
        long totalUploadFileCounterMillis = 0L;
        while (directoryIterator.hasNext()) {
            Response pushRepresentationResp2;
            File file = (File)directoryIterator.next();
            String filename = file.getName();
            String[] filenameSplits = filename.split("_");
            String localId = filenameSplits[0];
            String representationName = filenameSplits[1];
            int version = Integer.parseInt(filenameSplits[2].split("\\.")[0].substring(1));
            recordWatch.start("record creation of local file : " + filename);
            taskWatch.start("Get or create cloud id for localId : " + localId);
            CloudId cloudId = this.getOrCreateCloudId(providerId, localId);
            taskWatch.stop();
            long millis = taskWatch.getLastTaskTimeMillis();
            totalGetCloudidCounterMillis += millis;
            taskWatch.start("Create representation");
            Response pushRepresentationResp = this.pushRepresentation(cloudId, representationName, providerId);
            taskWatch.stop();
            millis = taskWatch.getLastTaskTimeMillis();
            totalCreateRepresentationCounterMillis += millis;
            if (pushRepresentationResp.getStatus() == Response.Status.CREATED.getStatusCode()) {
                pushRepresentationResp2 = client.target(pushRepresentationResp.getLocation()).request().get();
                if (pushRepresentationResp2.getStatus() != Response.Status.OK.getStatusCode()) {
                    System.out.println("Could not retrieve newly created representation for '" + cloudId.getId() + "'!");
                    continue;
                }
            } else {
                System.out.println("Could not create representation for '" + cloudId.getId() + "'!");
                continue;
            }
            Representation representation = (Representation)pushRepresentationResp2.readEntity(Representation.class);
            taskWatch.start("Upload file version");
            Response uploadFileResp = this.uploadFileOperation(file, representation);
            taskWatch.stop();
            millis = taskWatch.getLastTaskTimeMillis();
            totalUploadFileCounterMillis += millis;
            taskWatch.start("Persist representation");
            Response persistResp2 = this.persistFileOperation(representation);
            taskWatch.stop();
            taskWatch.start("Assign representation to dataset");
            Response assignResp = this.assignRepresentationIntoDataset(providerId, datasetId, representation);
            taskWatch.stop();
            recordWatch.stop();
        }
        System.out.println(taskWatch.prettyPrint());
        System.out.println(recordWatch.prettyPrint());
        System.out.println("Get or create cloud ids took in total : " + totalGetCloudidCounterMillis);
        System.out.println("Create record representation took in total : " + totalCreateRepresentationCounterMillis);
    }

    public CloudId getOrCreateCloudId(String providerId, String localId) {
        Response resp = client.target(SERVICES_ENDPOINT + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{providerId}).queryParam("recordId", new Object[]{localId}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (CloudId)resp.readEntity(CloudId.class);
        }
        resp = client.target(SERVICES_ENDPOINT + UIS_PREFIX + "/cloudIds").queryParam("providerId", new Object[]{providerId}).queryParam("recordId", new Object[]{localId}).request().post(Entity.json((Object)""));
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (CloudId)resp.readEntity(CloudId.class);
        }
        return null;
    }

    public Response pushRepresentation(CloudId cloudId, String representationName, String providerId) {
        String representationUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/records/" + cloudId.getId() + "/representations/" + representationName;
        Form form = new Form();
        form.param("providerId", providerId);
        Response response = client.target(representationUrl).request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return response;
    }

    public Response uploadFileOperation(File input, Representation representation) {
        eu.europeana.cloud.common.model.File cloudFile = new eu.europeana.cloud.common.model.File();
        cloudFile.setFileName(input.getName());
        cloudFile.setMimeType(FilenameUtils.getExtension((String)input.getAbsolutePath()));
        cloudFile.setMimeType("text");
        byte[] content = null;
        try {
            content = FileUtils.readFileToByteArray((File)input);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", cloudFile.getMimeType()).field("data", (Object)new ByteArrayInputStream(content), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName() + "/versions/" + representation.getVersion() + "/files/";
        Response resp = client.target(targetUrl).request().post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        System.out.println("resp : " + resp);
        return resp;
    }

    public Response persistFileOperation(Representation representation) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/records/" + representation.getCloudId() + "/representations/" + representation.getRepresentationName() + "/versions/" + representation.getVersion() + "/persist";
        Response resp = client.target(targetUrl).request().post(Entity.json((Object)""));
        System.out.println("persist: " + resp.toString());
        return resp;
    }

    public Response assignRepresentationIntoDataset(String providerId, String dataSetId, Representation representation) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/data-providers/" + providerId + "/data-sets/" + dataSetId + "/assignments/";
        Form form = new Form();
        form.param("cloudId", representation.getCloudId());
        form.param("representationName", representation.getRepresentationName());
        form.param("version", representation.getVersion());
        Response resp = client.target(targetUrl).request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        System.out.println(resp.toString());
        return resp;
    }

    public Response createDataset(String dataProviderId, String datasetId, String description) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/data-providers/" + dataProviderId + "/data-sets/";
        Form form = new Form();
        form.param("dataSetId", datasetId);
        form.param("description", description);
        Response resp = client.target(targetUrl).request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp;
    }

    public Response createProvider(String providerId, DataProviderProperties dp) {
        String targetUrl = SERVICES_ENDPOINT + UIS_PREFIX + "/data-providers/";
        Response createProviderResp = client.target(targetUrl).queryParam("providerId", new Object[]{providerId}).request().post(Entity.json((Object)dp));
        return createProviderResp;
    }

    private void deleteProviderDatasets(String providerId) {
        List<DataSet> datasets = this.getProvidersDatasets(providerId);
        boolean count = false;
        for (DataSet dataSet : datasets) {
            this.deleteDataSetAndRecords(dataSet);
            if (count) continue;
            break;
        }
    }

    private List<DataSet> getProvidersDatasets(String providerId) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/data-providers/" + providerId + "/data-sets/";
        Response resp = client.target(targetUrl).request().get();
        ResultSlice datasets = null;
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            System.out.println("Could read provider's : " + providerId + " datasets");
            return null;
        }
        datasets = (ResultSlice)resp.readEntity(ResultSlice.class);
        return datasets.getResults();
    }

    private void deleteRecord(String cloudId) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/records/" + cloudId;
        Response resp = client.target(targetUrl).request().delete();
        if (resp.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            System.out.println("Record " + cloudId + " succesfully deleted (with all representations and versions)");
        } else {
            System.out.println("Could not delete " + cloudId + " : " + resp.getStatus() + " : " + resp.toString());
        }
    }

    private void deleteDataset(DataSet dataSet) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "data-providers/" + dataSet.getProviderId() + "/data-sets/" + dataSet.getId() + "/";
        Response resp = client.target(targetUrl).request().delete();
        if (resp.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            System.out.println("Dataset " + dataSet.getId() + " succesfully deleted.");
        } else {
            System.out.println("Dataset " + dataSet.getId() + " deletion failed..");
            System.out.println(dataSet.toString());
            System.out.println(resp.toString());
        }
    }

    private void deleteDataSetAndRecords(DataSet dataSet) {
        List<Representation> datasetRecords = this.getDatasetRecords(dataSet);
        for (Representation representation : datasetRecords) {
            this.deleteRecord(representation.getCloudId());
        }
        this.deleteDataset(dataSet);
    }

    private List<Representation> getDatasetRecords(DataSet dataSet) {
        String targetUrl = SERVICES_ENDPOINT + MCS_PREFIX + "/data-providers/" + dataSet.getProviderId() + "/data-sets/" + dataSet.getId() + "/";
        System.out.println(targetUrl);
        Response resp = client.target(targetUrl).request().get();
        ResultSlice records = null;
        if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
            System.out.println("Could read dataSet's : " + dataSet.getId() + " representations...");
            System.out.println(resp.toString());
            return null;
        }
        records = (ResultSlice)resp.readEntity(ResultSlice.class);
        for (Representation repr : records.getResults()) {
            System.out.println(repr);
        }
        return records.getResults();
    }

    public static DigestInputStream md5InputStream(InputStream is) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new DigestInputStream(is, md);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError("Cannot get instance of MD5 but such algorithm should be provided", ex);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            System.out.println("args[" + i + "] : " + string);
        }
        OUDatasetPerformanceTest ouPerfTest = new OUDatasetPerformanceTest();
        CmdLineParser parser = new CmdLineParser((Object)ouPerfTest);
        try {
            parser.parseArgument(args);
            ouPerfTest.ingest();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

